/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsQuery;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.moderne.RepositoryInput;
import io.moderne.dx.artifacts.storage.LstMetadataRepository;
import io.moderne.dx.graphql.ExtendedRelayConnection;
import io.moderne.dx.organization.OrganizationService;
import io.moderne.dx.types.AstArtifact;
import io.moderne.dx.types.BitbucketCloudRepository;
import io.moderne.dx.types.BitbucketRepository;
import io.moderne.dx.types.CommitOption;
import io.moderne.dx.types.GitHubRepository;
import io.moderne.dx.types.GitLabRepository;
import io.moderne.dx.types.Organization;
import io.moderne.dx.types.OrphanedRepository;
import io.moderne.dx.types.Repository;
import io.moderne.dx.types.RepositoryBuild;
import io.moderne.dx.types.RepositoryFilter;
import io.moderne.dx.types.Statistics;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.springframework.web.bind.annotation.RequestHeader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@DgsComponent
public class RepositoryDataFetcher {
    private final OrganizationService a;
    private final LstMetadataRepository b;

    @DgsQuery
    public Mono<DataFetcherResult<List<Organization>>> organizations(@RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string, @Nullable @InputArgument String string2) {
        Flux flux = string2 == null ? this.a.findAll(string) : this.a.filterById(string, string2);
        return flux.collectList().map(list -> DataFetcherResult.newResult().data(list).localContext(list).build());
    }

    @DgsQuery
    public Mono<DataFetcherResult<Organization>> organization(@RequestHeader(name="x-moderne-authemail", required=false, defaultValue="dev@null") String string, @InputArgument String string2) {
        return this.a.filterById(string, string2).collectList().flatMap(list -> {
            Organization organization2 = list.stream().filter(organization -> organization.getId().equals(string2)).findFirst().orElse(null);
            if (organization2 == null) {
                return Mono.error((Throwable)new DgsEntityNotFoundException("No organization found for id \"" + string2 + "\"."));
            }
            return Mono.justOrEmpty((Object)organization2).map(organization -> DataFetcherResult.newResult().data(organization).localContext(list).build());
        });
    }

    @DgsQuery
    Flux<CommitOption> defaultCommitOptions() {
        return this.a.defaultCommitOptions();
    }

    @DgsData(parentType="Organization")
    public Mono<Statistics> statistics(DataFetchingEnvironment dataFetchingEnvironment) {
        Organization organization = (Organization)dataFetchingEnvironment.getSource();
        List list = (List)dataFetchingEnvironment.getLocalContext();
        Flux flux = this.a.filterById(Flux.fromIterable((Iterable)list), organization.getId()).cache();
        return this.a.countRepositories(flux, repository -> true).map(Statistics::new);
    }

    @DgsData(parentType="Organization")
    public Mono<ExtendedRelayConnection<Repository>> repositoriesPages(DataFetchingEnvironment dataFetchingEnvironment, @InputArgument RepositoryFilter repositoryFilter) {
        Predicate<Repository> predicate = repository -> repositoryFilter.getShowMissing() == Boolean.TRUE || RepositoryDataFetcher.a((Repository)repository) != null;
        Organization organization = (Organization)dataFetchingEnvironment.getSource();
        List list = (List)dataFetchingEnvironment.getLocalContext();
        Flux flux = this.a.filterById(Flux.fromIterable((Iterable)list), organization.getId()).cache();
        return ExtendedRelayConnection.getConnection((DataFetchingEnvironment)dataFetchingEnvironment, (Mono)this.a.countRepositories(flux, predicate), limitOffset -> this.a.findRepositories(flux, organization.getId(), limitOffset.getOffset(), limitOffset.getLimit(), predicate));
    }

    @Nullable
    private static OffsetDateTime a(Repository repository) {
        if (repository instanceof GitHubRepository) {
            GitHubRepository gitHubRepository = (GitHubRepository)repository;
            return gitHubRepository.getIngested();
        }
        if (repository instanceof GitLabRepository) {
            GitLabRepository gitLabRepository = (GitLabRepository)repository;
            return gitLabRepository.getIngested();
        }
        if (repository instanceof BitbucketRepository) {
            BitbucketRepository bitbucketRepository = (BitbucketRepository)repository;
            return bitbucketRepository.getIngested();
        }
        if (repository instanceof BitbucketCloudRepository) {
            BitbucketCloudRepository bitbucketCloudRepository = (BitbucketCloudRepository)repository;
            return bitbucketCloudRepository.getIngested();
        }
        if (repository instanceof OrphanedRepository) {
            OrphanedRepository orphanedRepository = (OrphanedRepository)repository;
            return orphanedRepository.getIngested();
        }
        throw new IllegalArgumentException("Unknown repository type: " + repository.getClass().getName());
    }

    @DgsQuery
    public Mono<RepositoryBuild> latestBuild(@InputArgument RepositoryInput repositoryInput) {
        return Mono.fromCallable(() -> this.b.a(repositoryInput)).map(a2 -> RepositoryBuild.newBuilder().buildId(a2.c()).ingested(Instant.ofEpochMilli(a2.g()).atOffset(ZoneOffset.UTC)).buildPluginName(a2.e()).buildPluginVersion(a2.f()).weight(a2.d().longValue()).changeset(a2.b()).asts(a2.h().stream().map(d2 -> AstArtifact.newBuilder().url(d2.a().toString()).location(d2.b()).timestamp(Instant.ofEpochMilli(d2.c()).atOffset(ZoneOffset.UTC)).build()).toList()).build());
    }

    @DgsMutation
    public Mono<Boolean> refreshOrganizations() {
        return this.a.refreshOrganizations();
    }

    @Generated
    public RepositoryDataFetcher(OrganizationService organizationService, LstMetadataRepository lstMetadataRepository) {
        this.a = organizationService;
        this.b = lstMetadataRepository;
    }
}

