/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.artifacts;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.moderne.RepositoryInput;
import io.moderne.dx.a;
import io.moderne.dx.artifacts.artifactory.Artifactory;
import io.moderne.dx.artifacts.b;
import io.moderne.dx.artifacts.c;
import io.moderne.dx.artifacts.d;
import io.moderne.dx.artifacts.f;
import io.moderne.dx.artifacts.g;
import io.moderne.dx.artifacts.storage.LstMetadataRepository;
import io.moderne.dx.config.ArtifactoryConfiguration;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.metrics.ReactorMetrics;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

@Service
class ArtifactIndexerImpl
implements io.moderne.dx.artifacts.a,
g {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(ArtifactIndexerImpl.class);
    private static final Scheduler b = Schedulers.newBoundedElastic((int)20, (int)10000, (String)"artifact-downloader");
    private final LstMetadataRepository c;
    private final List<c> d;
    private final Set<d> e;

    public ArtifactIndexerImpl(DxConfiguration dxConfiguration, LstMetadataRepository lstMetadataRepository, WebClient.Builder builder) {
        this.c = lstMetadataRepository;
        List list = dxConfiguration.getMaven() == null ? Collections.emptyList() : dxConfiguration.getMaven();
        List list2 = dxConfiguration.getArtifactory() == null ? Collections.emptyList() : dxConfiguration.getArtifactory();
        this.d = new ArrayList(list.size() + list2.size());
        for (ArtifactoryConfiguration artifactoryConfiguration : list2) {
            WebClient.Builder builder2 = builder.clone().codecs(clientCodecConfigurer -> clientCodecConfigurer.defaultCodecs().maxInMemorySize(0x1000000));
            if (artifactoryConfiguration.isSkipSsl()) {
                a.a((WebClient.Builder)builder2);
            }
            this.d.add(new Artifactory(artifactoryConfiguration, b, builder2));
        }
        Scheduler scheduler = Schedulers.newBoundedElastic((int)1, (int)1, (String)"artifact-sync");
        Flux.interval((Duration)Duration.ofSeconds(10L), (Duration)dxConfiguration.artifactSyncInterval()).publishOn(scheduler).onBackpressureDrop(l2 -> {
            a.trace("[Artifact] {} trigger{} dropped.", l2, (Object)(l2 == 1L ? "" : "s"));
            Metrics.counter((String)"moderne.dx.artifacts.sync.dropped", (String[])new String[0]).increment();
        }).doOnNext(l2 -> a.debug("[Artifact] Sync started.")).concatMap(l2 -> this.a(null).doOnNext(d2 -> a.trace("[Artifact] Listed artifact: {}", d2)).collectList().doOnNext(list -> a.debug("[Artifact] Listed {} artifacts.", (Object)list.size())).flatMapMany(Flux::fromIterable).transform(this.a(false)).onErrorContinue((throwable, object) -> a.debug("[Artifact] Describe failed.", throwable)).doOnComplete(() -> a.debug("[Artifact] Sync Completed.")).buffer(10).doOnNext(list -> a.debug("[Artifact] Described batch of {} artifacts.", (Object)list.size()))).transform(ReactorMetrics.recordFluxMetrics((Timer.Sample)Timer.start(), (Timer.Builder)Timer.builder((String)"moderne.dx.artifacts.sync"))).onErrorContinue((throwable, object) -> a.debug("[Artifact] Sync failed.", throwable)).doFinally(signalType -> a.error("[Artifact] Sync terminated unexpectedly with signal {}", signalType)).subscribeOn(scheduler).subscribe();
        this.e = Collections.newSetFromMap(new b(this));
    }

    public Flux<d> a(@Nullable ZonedDateTime zonedDateTime) {
        return Flux.fromIterable((Iterable)this.d).filter(c::isAstSource).publishOn(b).flatMap(c2 -> {
            ZonedDateTime zonedDateTime2 = Objects.requireNonNullElseGet(zonedDateTime, () -> this.c.a(c2.getUri()));
            return c2.listAstArtifacts(zonedDateTime2);
        }).transform(ReactorMetrics.recordFluxMetrics((Timer.Sample)Timer.start(), (Timer.Builder)Timer.builder((String)"moderne.dx.artifacts.list"))).doOnComplete(() -> a.debug("Listing artifact updates complete."));
    }

    public Function<Flux<d>, Flux<f>> a(boolean bl) {
        return flux -> flux.publishOn(b).filter(this.e::add).flatMap(d2 -> {
            c c2 = this.a(d2);
            return c2.describeAst(Mono.just((Object)d2)).map(e2 -> new f(e2.a(), e2.c(), e2.d(), e2.e(), e2.f(), e2.g(), d2)).onErrorResume(throwable -> {
                a.trace("Warn: Unable to describe artifact: {}", (Object)d2.b(), throwable);
                return Mono.empty();
            });
        }).flatMap(f2 -> {
            String string = f2.a().getBranch();
            if (StringUtils.isEmpty((CharSequence)string) || string.equals(f2.b())) {
                return Mono.error((Throwable)new IllegalStateException("Detached head."));
            }
            if (!bl) {
                this.c.a(f2);
            }
            return Mono.just((Object)f2);
        }).doOnComplete(() -> a.debug("Describing artifacts complete.")).retryWhen((Retry)Retry.max((long)2L).doBeforeRetry(retrySignal -> a.debug("Retrying describe artifact."))).onErrorResume(throwable -> {
            a.debug("Failed to describe artifact.", throwable);
            return Mono.empty();
        }).transform(ReactorMetrics.recordFluxMetrics((Timer.Sample)Timer.start(), (Timer.Builder)Timer.builder((String)"moderne.dx.artifacts.describe"))).subscribeOn(b);
    }

    private c a(d d2) {
        return this.d.stream().filter(c2 -> c2.getUri().equals(d2.a())).findAny().orElseThrow(() -> new IllegalArgumentException("unknown artifact repository: " + d2.a()));
    }

    public Collection<io.moderne.dx.artifacts.storage.a> a() {
        return this.c.a();
    }

    public io.moderne.dx.artifacts.storage.a a(RepositoryInput repositoryInput) {
        return this.c.a(repositoryInput);
    }
}

