/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.config;

import io.moderne.dx.config.ArtifactRepository;
import io.moderne.dx.config.ArtifactSync;
import io.moderne.dx.config.ArtifactoryConfiguration;
import io.moderne.dx.config.MavenConfiguration;
import io.moderne.dx.config.OrganizationConfiguration;
import io.moderne.dx.config.RecipeConfig;
import io.moderne.dx.config.ScmConfiguration;
import io.moderne.dx.config.StorageConfig;
import io.moderne.dx.validators.connectivity.CanConnect;
import java.time.Duration;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="moderne.dx")
public final class DxConfiguration {
    private final List<@CanConnect ArtifactoryConfiguration> artifactory;
    private final List<@CanConnect MavenConfiguration> maven;
    private final String licenseKey;
    private final List<String> token;
    private final List<ScmConfiguration> scm;
    private final OrganizationConfiguration organization;
    private final ArtifactSync artifactSync;
    private final StorageConfig storage;
    private final RecipeConfig recipe;

    public Duration artifactSyncInterval() {
        return this.artifactSync == null ? ArtifactSync.DEFAULT_INTERVAL : this.artifactSync.interval();
    }

    public LocalDate getArtifactSyncSince() {
        return this.artifactSync == null ? ArtifactSync.DEFAULT_SINCE : this.artifactSync.since();
    }

    public boolean isUseOnlyConfigured() {
        return this.recipe != null && Boolean.TRUE.equals(this.recipe.useOnlyConfigured());
    }

    public List<ArtifactRepository> artifactRepositories() {
        ArrayList<ArtifactRepository> arrayList = new ArrayList<ArtifactRepository>();
        if (this.maven != null) {
            arrayList.addAll(this.maven);
        }
        if (this.artifactory != null) {
            arrayList.addAll(this.artifactory);
        }
        return arrayList;
    }

    @Generated
    public DxConfiguration(List<@CanConnect ArtifactoryConfiguration> list, List<@CanConnect MavenConfiguration> list2, String string, List<String> list3, List<ScmConfiguration> list4, OrganizationConfiguration organizationConfiguration, ArtifactSync artifactSync, StorageConfig storageConfig, RecipeConfig recipeConfig) {
        this.artifactory = list;
        this.maven = list2;
        this.licenseKey = string;
        this.token = list3;
        this.scm = list4;
        this.organization = organizationConfiguration;
        this.artifactSync = artifactSync;
        this.storage = storageConfig;
        this.recipe = recipeConfig;
    }

    @Generated
    public List<@CanConnect ArtifactoryConfiguration> getArtifactory() {
        return this.artifactory;
    }

    @Generated
    public List<@CanConnect MavenConfiguration> getMaven() {
        return this.maven;
    }

    @Generated
    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Generated
    public List<String> getToken() {
        return this.token;
    }

    @Generated
    public List<ScmConfiguration> getScm() {
        return this.scm;
    }

    @Generated
    public OrganizationConfiguration getOrganization() {
        return this.organization;
    }

    @Generated
    public ArtifactSync getArtifactSync() {
        return this.artifactSync;
    }

    @Generated
    public StorageConfig getStorage() {
        return this.storage;
    }

    @Generated
    public RecipeConfig getRecipe() {
        return this.recipe;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DxConfiguration)) {
            return false;
        }
        DxConfiguration dxConfiguration = (DxConfiguration)object;
        List list = this.getArtifactory();
        List list2 = dxConfiguration.getArtifactory();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List list3 = this.getMaven();
        List list4 = dxConfiguration.getMaven();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        String string = this.getLicenseKey();
        String string2 = dxConfiguration.getLicenseKey();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List list5 = this.getToken();
        List list6 = dxConfiguration.getToken();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        List list7 = this.getScm();
        List list8 = dxConfiguration.getScm();
        if (list7 == null ? list8 != null : !((Object)list7).equals(list8)) {
            return false;
        }
        OrganizationConfiguration organizationConfiguration = this.getOrganization();
        OrganizationConfiguration organizationConfiguration2 = dxConfiguration.getOrganization();
        if (organizationConfiguration == null ? organizationConfiguration2 != null : !organizationConfiguration.equals(organizationConfiguration2)) {
            return false;
        }
        ArtifactSync artifactSync = this.getArtifactSync();
        ArtifactSync artifactSync2 = dxConfiguration.getArtifactSync();
        if (artifactSync == null ? artifactSync2 != null : !artifactSync.equals(artifactSync2)) {
            return false;
        }
        StorageConfig storageConfig = this.getStorage();
        StorageConfig storageConfig2 = dxConfiguration.getStorage();
        if (storageConfig == null ? storageConfig2 != null : !storageConfig.equals(storageConfig2)) {
            return false;
        }
        RecipeConfig recipeConfig = this.getRecipe();
        RecipeConfig recipeConfig2 = dxConfiguration.getRecipe();
        return !(recipeConfig == null ? recipeConfig2 != null : !recipeConfig.equals(recipeConfig2));
    }

    @Generated
    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        List list = this.getArtifactory();
        n3 = n3 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List list2 = this.getMaven();
        n3 = n3 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        String string = this.getLicenseKey();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        List list3 = this.getToken();
        n3 = n3 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        List list4 = this.getScm();
        n3 = n3 * 59 + (list4 == null ? 43 : ((Object)list4).hashCode());
        OrganizationConfiguration organizationConfiguration = this.getOrganization();
        n3 = n3 * 59 + (organizationConfiguration == null ? 43 : organizationConfiguration.hashCode());
        ArtifactSync artifactSync = this.getArtifactSync();
        n3 = n3 * 59 + (artifactSync == null ? 43 : artifactSync.hashCode());
        StorageConfig storageConfig = this.getStorage();
        n3 = n3 * 59 + (storageConfig == null ? 43 : storageConfig.hashCode());
        RecipeConfig recipeConfig = this.getRecipe();
        n3 = n3 * 59 + (recipeConfig == null ? 43 : recipeConfig.hashCode());
        return n3;
    }

    @Generated
    public String toString() {
        return "DxConfiguration(artifactory=" + this.getArtifactory() + ", maven=" + this.getMaven() + ", licenseKey=" + this.getLicenseKey() + ", token=" + this.getToken() + ", scm=" + this.getScm() + ", organization=" + this.getOrganization() + ", artifactSync=" + this.getArtifactSync() + ", storage=" + this.getStorage() + ", recipe=" + this.getRecipe() + ")";
    }
}

