/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.config;

import io.moderne.dx.types.CommitOption;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;

public class OrganizationConfiguration {
    static Duration DEFAULT_SYNC_INTERVAL = Duration.ofMinutes(10L);
    @Nullable
    private URL url;
    @Nullable
    private Long syncIntervalSeconds;
    private List<CommitOption> defaultCommitOptions;
    private boolean skipSsl;
    @Nullable
    private Path reposCsv;

    public List<CommitOption> getDefaultCommitOptions() {
        if (this.defaultCommitOptions == null) {
            return List.of(CommitOption.Direct, CommitOption.Branch, CommitOption.Fork, CommitOption.PullRequest, CommitOption.ForkAndPullRequest);
        }
        return this.defaultCommitOptions;
    }

    public Duration syncIntervalDuration() {
        if (this.syncIntervalSeconds == null) {
            return DEFAULT_SYNC_INTERVAL;
        }
        return Duration.ofSeconds(this.syncIntervalSeconds);
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public Long getSyncIntervalSeconds() {
        return this.syncIntervalSeconds;
    }

    @Generated
    public boolean isSkipSsl() {
        return this.skipSsl;
    }

    @Generated
    public Path getReposCsv() {
        return this.reposCsv;
    }

    @Generated
    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    @Generated
    public void setSyncIntervalSeconds(Long l2) {
        this.syncIntervalSeconds = l2;
    }

    @Generated
    public void setDefaultCommitOptions(List<CommitOption> list) {
        this.defaultCommitOptions = list;
    }

    @Generated
    public void setSkipSsl(boolean bl) {
        this.skipSsl = bl;
    }

    @Generated
    public void setReposCsv(Path path) {
        this.reposCsv = path;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OrganizationConfiguration)) {
            return false;
        }
        OrganizationConfiguration organizationConfiguration = (OrganizationConfiguration)object;
        if (!organizationConfiguration.canEqual((Object)this)) {
            return false;
        }
        if (this.isSkipSsl() != organizationConfiguration.isSkipSsl()) {
            return false;
        }
        Long l2 = this.getSyncIntervalSeconds();
        Long l3 = organizationConfiguration.getSyncIntervalSeconds();
        if (l2 == null ? l3 != null : !((Object)l2).equals(l3)) {
            return false;
        }
        URL uRL = this.getUrl();
        URL uRL2 = organizationConfiguration.getUrl();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        List list = this.getDefaultCommitOptions();
        List list2 = organizationConfiguration.getDefaultCommitOptions();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        Path path = this.getReposCsv();
        Path path2 = organizationConfiguration.getReposCsv();
        return !(path == null ? path2 != null : !((Object)path).equals(path2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof OrganizationConfiguration;
    }

    @Generated
    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isSkipSsl() ? 79 : 97);
        Long l2 = this.getSyncIntervalSeconds();
        n3 = n3 * 59 + (l2 == null ? 43 : ((Object)l2).hashCode());
        URL uRL = this.getUrl();
        n3 = n3 * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        List list = this.getDefaultCommitOptions();
        n3 = n3 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        Path path = this.getReposCsv();
        n3 = n3 * 59 + (path == null ? 43 : ((Object)path).hashCode());
        return n3;
    }

    @Generated
    public String toString() {
        return "OrganizationConfiguration(url=" + this.getUrl() + ", syncIntervalSeconds=" + this.getSyncIntervalSeconds() + ", defaultCommitOptions=" + this.getDefaultCommitOptions() + ", skipSsl=" + this.isSkipSsl() + ", reposCsv=" + this.getReposCsv() + ")";
    }

    @Generated
    public OrganizationConfiguration(URL uRL, Long l2, List<CommitOption> list, boolean bl, Path path) {
        this.url = uRL;
        this.syncIntervalSeconds = l2;
        this.defaultCommitOptions = list;
        this.skipSsl = bl;
        this.reposCsv = path;
    }

    @Generated
    public OrganizationConfiguration() {
    }
}

