/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.organization;

import io.moderne.dx.organization.ShallowOrganization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.Nullable;

class OrganizationTree {
    private final Map<String, ShallowOrganization> organizations = new LinkedHashMap();

    public OrganizationTree(Collection<ShallowOrganization> collection) {
        for (ShallowOrganization shallowOrganization : collection) {
            this.organizations.put(shallowOrganization.id(), shallowOrganization);
        }
    }

    @Nullable
    public ShallowOrganization findById(String string) {
        return (ShallowOrganization)this.organizations.get(string);
    }

    public List<ShallowOrganization> findByIdIncludingChildren(String string) {
        ArrayList<ShallowOrganization> arrayList = new ArrayList<ShallowOrganization>();
        ShallowOrganization shallowOrganization = (ShallowOrganization)this.organizations.get(string);
        if (shallowOrganization != null) {
            this.findSubtree(shallowOrganization, arrayList);
        }
        return arrayList;
    }

    public List<ShallowOrganization> findAll() {
        return this.organizations.values().stream().filter(shallowOrganization -> shallowOrganization.parent() == null || !this.organizations.containsKey(shallowOrganization.parent().id())).flatMap(shallowOrganization -> {
            ArrayList arrayList = new ArrayList();
            this.findSubtree(shallowOrganization, arrayList);
            return arrayList.stream();
        }).collect(Collectors.toList());
    }

    private void findSubtree(ShallowOrganization shallowOrganization, List<ShallowOrganization> list) {
        LinkedList<ShallowOrganization> linkedList = new LinkedList<ShallowOrganization>();
        linkedList.offer(shallowOrganization);
        while (!linkedList.isEmpty()) {
            ShallowOrganization shallowOrganization2 = (ShallowOrganization)linkedList.poll();
            list.add(shallowOrganization2);
            for (ShallowOrganization shallowOrganization3 : this.organizations.values()) {
                if (shallowOrganization3.parent() == null || !shallowOrganization3.parent().id().equals(shallowOrganization2.id())) continue;
                linkedList.offer(shallowOrganization3);
            }
        }
    }
}

