/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.recipe;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.netflix.graphql.dgs.exceptions.DgsEntityNotFoundException;
import io.moderne.cli.IdGenerator;
import io.moderne.cli.recipe.InstallableRecipeJar;
import io.moderne.cli.recipe.RecipeDeployment;
import io.moderne.cli.recipe.RecipeMarketplace;
import io.moderne.cli.recipe.RecipeResolver;
import io.moderne.dx.config.ArtifactRepository;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.dx.recipe.a;
import io.moderne.dx.recipe.b;
import io.moderne.dx.types.RecipeArtifact;
import io.moderne.dx.types.RecipeDeploymentResult;
import io.moderne.dx.types.RecipeDeploymentState;
import jakarta.annotation.PostConstruct;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RecipeDeployer {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(RecipeDeployer.class);
    private static final Scheduler b = Schedulers.newBoundedElastic((int)1, (int)10000, (String)"recipe-loading");
    private final RecipeMarketplace c;
    private final DxConfiguration d;
    private final Cache<@NonNull GroupArtifact, @NonNull a> e = Caffeine.newBuilder().recordStats().build();

    @PostConstruct
    void a() {
        for (RecipeDeployment recipeDeployment : this.c.listDeployments()) {
            ResolvedGroupArtifactVersion resolvedGroupArtifactVersion = recipeDeployment.getArtifact();
            this.e.put((Object)new GroupArtifact(resolvedGroupArtifactVersion.getGroupId(), resolvedGroupArtifactVersion.getArtifactId()), (Object)new a(recipeDeployment.getRequestedVersion(), new RecipeDeploymentResult(recipeDeployment.getId(), RecipeDeploymentState.FINISHED, null, b.a((ResolvedGroupArtifactVersion)resolvedGroupArtifactVersion))));
        }
        Mono.just((Object)1).repeat().delayUntil(n2 -> Mono.delay((Duration)Duration.ofMillis(250L))).flatMap(n2 -> Flux.fromIterable(this.e.asMap().values()).map(a::b).filter(recipeDeploymentResult -> recipeDeploymentResult.getState() == RecipeDeploymentState.QUEUED).flatMap(recipeDeploymentResult -> this.a(new GroupArtifact(recipeDeploymentResult.getArtifact().getGroupId(), recipeDeploymentResult.getArtifact().getArtifactId())).onErrorResume(throwable -> {
            a.error("Error in loading recipe.", throwable);
            return Mono.empty();
        }))).subscribe();
    }

    public Flux<RecipeDeploymentResult> a(Predicate<RecipeDeploymentResult> predicate) {
        return Flux.fromIterable(this.e.asMap().values()).map(a::b).filter(predicate);
    }

    public Mono<RecipeDeploymentResult> a(String string, String string2, String string3, String string4) {
        return Mono.fromCallable(() -> {
            RecipeDeploymentResult recipeDeploymentResult = new RecipeDeploymentResult(IdGenerator.randomId(), RecipeDeploymentState.QUEUED, null, new RecipeArtifact(string, string2, string3, null, null, null));
            this.e.put((Object)new GroupArtifact(string, string2), (Object)new a(string4 == null ? string3 : string4, recipeDeploymentResult));
            return recipeDeploymentResult;
        });
    }

    private Mono<RecipeArtifact> a(GroupArtifact groupArtifact) {
        String string = groupArtifact.getGroupId();
        String string2 = groupArtifact.getArtifactId();
        a a2 = (a)this.e.getIfPresent((Object)groupArtifact);
        if (a2 == null) {
            return Mono.error((Throwable)new DgsEntityNotFoundException("Recipe deployment not found"));
        }
        RecipeDeploymentResult recipeDeploymentResult = a2.b();
        recipeDeploymentResult.setState(RecipeDeploymentState.LOADING);
        return Flux.fromIterable((Iterable)this.d.artifactRepositories()).filter(ArtifactRepository::isRecipeSource).publishOn(b).concatMap(artifactRepository -> {
            RecipeArtifact recipeArtifact = RecipeDeployer.a((RecipeMarketplace)this.c, (String)string, (String)string2, (String)a2.a(), (ArtifactRepository)artifactRepository, (boolean)this.d.isUseOnlyConfigured());
            return Mono.justOrEmpty((Object)recipeArtifact);
        }).next().doOnNext(recipeArtifact -> {
            recipeDeploymentResult.setArtifact(recipeArtifact);
            recipeDeploymentResult.setState(RecipeDeploymentState.FINISHED);
        }).switchIfEmpty(Mono.error((Throwable)new IllegalStateException("Recipe %s:%s not found".formatted(string, string2)))).doOnError(throwable -> {
            recipeDeploymentResult.setStateMessage(throwable.getMessage());
            recipeDeploymentResult.setState(RecipeDeploymentState.ERROR);
        }).subscribeOn(b);
    }

    @Nullable
    static synchronized RecipeArtifact a(RecipeMarketplace recipeMarketplace, String string, String string2, String string3, ArtifactRepository artifactRepository, boolean bl) {
        PrintWriter printWriter;
        a.debug("[Recipe] Trying to load recipe [{}:{}] from: {}", new Object[]{string, string2, artifactRepository.getUri()});
        GroupArtifactVersion groupArtifactVersion2 = new GroupArtifactVersion(string, string2, string3);
        try {
            Object object;
            printWriter = new PrintWriter("/dev/null");
            recipeMarketplace.uninstall(Objects.requireNonNull(groupArtifactVersion2.getGroupId()), groupArtifactVersion2.getArtifactId());
            MavenSettings.HttpHeader httpHeader = null;
            if (StringUtils.isNotBlank((CharSequence)artifactRepository.getPassword())) {
                object = "Basic %s".formatted(Base64.getEncoder().encodeToString("%s:%s".formatted(artifactRepository.getUsername(), artifactRepository.getPassword()).getBytes()));
                httpHeader = new MavenSettings.HttpHeader("Authorization", (String)object);
            }
            object = new io.moderne.cli.config.ArtifactRepository(artifactRepository.getUrl(), artifactRepository.isSkipSsl(), httpHeader);
            InstallableRecipeJar installableRecipeJar = RecipeResolver.resolve((GroupArtifactVersion)groupArtifactVersion2, (io.moderne.cli.config.ArtifactRepository)object, (PrintWriter)printWriter, (boolean)artifactRepository.isSkipSsl(), (!bl ? 1 : 0) != 0, (RecipeMarketplace)recipeMarketplace, resolvedGroupArtifactVersion -> a.trace("[Recipe] Recipe dependency resolved: {}:{}:{}[{}]@{}", new Object[]{resolvedGroupArtifactVersion.getGroupId(), resolvedGroupArtifactVersion.getArtifactId(), resolvedGroupArtifactVersion.getVersion(), resolvedGroupArtifactVersion.getDatedSnapshotVersion(), resolvedGroupArtifactVersion.getRepository()}), (groupArtifactVersion, list) -> a.warn("[Recipe] Failed to resolve recipe dependency: {}:{}:{} from: \n - {}", new Object[]{groupArtifactVersion.getGroupId(), groupArtifactVersion.getArtifactId(), groupArtifactVersion.getVersion(), String.join((CharSequence)"\n - ", list)}));
            recipeMarketplace.install(installableRecipeJar, UUID.randomUUID().toString(), recipeMarketplace.recipeIndexFile);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof MavenDownloadingExceptions) {
                MavenDownloadingExceptions mavenDownloadingExceptions = (MavenDownloadingExceptions)throwable2;
                a.warn("Unable to install recipe: {} - {}", new Object[]{groupArtifactVersion2, ((MavenDownloadingException)mavenDownloadingExceptions.getExceptions().get(0)).getMessage(), mavenDownloadingExceptions});
                throw new RuntimeException((Throwable)mavenDownloadingExceptions.getExceptions().get(0));
            }
            throwable2 = throwable.getCause();
            if (throwable2 instanceof MavenDownloadingException) {
                MavenDownloadingException mavenDownloadingException = (MavenDownloadingException)throwable2;
                a.warn("Unable to install recipe: {} - {}", new Object[]{groupArtifactVersion2, mavenDownloadingException.getMessage(), mavenDownloadingException});
            } else {
                a.error("[Recipe] Unable to install recipe [{}:{}] from: {}", new Object[]{string, string2, artifactRepository.getUri(), throwable});
            }
            throw new RuntimeException(throwable);
        }
        printWriter = recipeMarketplace.countByArtifact().keySet().stream().filter(resolvedGroupArtifactVersion -> resolvedGroupArtifactVersion.getGroupId().equals(string) && resolvedGroupArtifactVersion.getArtifactId().equals(string2)).map(b::a).findAny().orElse(null);
        if (printWriter == null) {
            a.trace("[Recipe] Recipe [{}:{}] not found in: {}", new Object[]{string, string2, artifactRepository.getUrl()});
        } else {
            a.debug("[Recipe] Recipe [{}:{}:{}] successfully loaded from: {}", new Object[]{string, string2, printWriter.getVersion(), artifactRepository.getUrl()});
        }
        return printWriter;
    }

    @Generated
    public RecipeDeployer(RecipeMarketplace recipeMarketplace, DxConfiguration dxConfiguration) {
        this.c = recipeMarketplace;
        this.d = dxConfiguration;
    }
}

