/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.moderne.cli.config.ConfigurationDirectory;
import io.moderne.cli.recipe.RecipeMarketplace;
import io.moderne.dx.artifacts.TypedRepositoryBuilder;
import io.moderne.dx.artifacts.g;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.dx.organization.OrganizationService;
import io.moderne.dx.organization.OrganizationStructureService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisRepositoriesAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.web.reactive.function.client.WebClient;
import picocli.CommandLine;
import reactor.core.publisher.Hooks;

@SpringBootApplication(exclude={RedisAutoConfiguration.class, RedisRepositoriesAutoConfiguration.class})
@EnableConfigurationProperties(value={DxConfiguration.class})
public class Application {
    @Generated
    private static final Logger a = LoggerFactory.getLogger(Application.class);

    public static void main(String[] stringArray) {
        ConfigurationDirectory.setRootDir((Path)Paths.get(System.getProperty("user.home"), ".moderne", "dx"));
        Hooks.onErrorDropped(throwable -> a.debug("Uncaught error", throwable));
        SpringApplication springApplication = new SpringApplication(new Class[]{Application.class});
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("management.endpoints.web.exposure.include", "health,prometheus");
        Properties properties = new Properties();
        File file = Path.of("dx/local.properties", new String[0]).toFile();
        if (!file.exists()) {
            file = Path.of("local.properties", new String[0]).toFile();
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put(entry.getKey().toString(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        springApplication.setDefaultProperties(hashMap);
        springApplication.run(stringArray);
    }

    @Bean
    CommandLine.Model.CommandSpec spec() {
        return CommandLine.Model.CommandSpec.create();
    }

    @Bean
    OrganizationService organizationService(DxConfiguration dxConfiguration, g g2, TypedRepositoryBuilder typedRepositoryBuilder, OrganizationStructureService organizationStructureService, WebClient.Builder builder) {
        if (dxConfiguration.getOrganization() != null) {
            if (dxConfiguration.getOrganization().getUrl() != null && dxConfiguration.getOrganization().getReposCsv() != null) {
                throw new IllegalStateException("moderne.dx.organization.url and moderne.dx.organization.reposCsv are mutually exclusive");
            }
            if (dxConfiguration.getOrganization().getUrl() != null) {
                return new OrganizationService.Connected(dxConfiguration, typedRepositoryBuilder, g2, builder);
            }
            if (dxConfiguration.getOrganization().getReposCsv() != null) {
                return new OrganizationService.Csv(dxConfiguration, organizationStructureService);
            }
            throw new IllegalStateException("moderne.dx.organization.url or moderne.dx.organization.reposCsv must be set");
        }
        return new OrganizationService.Disconnected(typedRepositoryBuilder, g2);
    }

    @Bean
    @Primary
    ObjectMapper defaultObjectMapper() {
        return ((JsonMapper)JsonMapper.builder().build()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new JavaTimeModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).setSerializationInclusion(JsonInclude.Include.NON_NULL).enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    @Bean
    RecipeMarketplace recipeMarketplace() {
        return new RecipeMarketplace();
    }
}

