/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.artifacts.artifactory;

import io.moderne.dx.artifacts.RepositoryTypeFinder;
import io.moderne.dx.artifacts.artifactory.AqlSearchResultsPage;
import io.moderne.dx.artifacts.c;
import io.moderne.dx.artifacts.d;
import io.moderne.dx.config.ArtifactoryConfiguration;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Base64;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class Artifactory
extends c {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Artifactory.class);
    private final ArtifactoryConfiguration configuration;
    private final WebClient webClient;

    public Artifactory(ArtifactoryConfiguration artifactoryConfiguration, Scheduler scheduler, RepositoryTypeFinder repositoryTypeFinder, WebClient.Builder builder) {
        super(scheduler, repositoryTypeFinder);
        this.configuration = artifactoryConfiguration;
        this.webClient = builder.build();
    }

    public URL getUrl() {
        return this.configuration.getUrl();
    }

    public URI getUri() {
        return this.configuration.getUri();
    }

    public boolean isAstSource() {
        return this.configuration.isAstSource();
    }

    public Flux<d> listAstArtifacts(@Nullable ZonedDateTime zonedDateTime) {
        if (!this.configuration.isAstSource()) {
            return Flux.empty();
        }
        ZonedDateTime zonedDateTime2 = zonedDateTime == null ? ZonedDateTime.of(1983, 12, 5, 0, 0, 0, 0, ZoneId.systemDefault()) : zonedDateTime.minusHours(2L);
        return this.fetchPage(this.configuration, zonedDateTime2, null).expand(aqlSearchResultsPage -> aqlSearchResultsPage.getRange().getLimit() != aqlSearchResultsPage.getRange().getTotal() ? Mono.empty() : this.fetchPage(this.configuration, zonedDateTime2, aqlSearchResultsPage)).map(AqlSearchResultsPage::getResults).flatMap(Flux::fromIterable).filter(aqlItem -> aqlItem.getName().contains("-ast.jar") || aqlItem.getName().contains("-lst.jar")).map(aqlItem -> {
            try {
                return new d(this.configuration.getUrl().toURI(), aqlItem.getRepo() + "/" + aqlItem.getPath() + "/" + aqlItem.getName(), aqlItem.getModified().toInstant().toEpochMilli());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException(uRISyntaxException);
            }
        });
    }

    private Mono<AqlSearchResultsPage> fetchPage(ArtifactoryConfiguration artifactoryConfiguration, ZonedDateTime zonedDateTime, @Nullable AqlSearchResultsPage aqlSearchResultsPage) {
        assert (artifactoryConfiguration.getAstQueryFilters() != null);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(artifactoryConfiguration.getUrl() + "/api/search/aql", new Object[0])).contentType(MediaType.TEXT_PLAIN).header("Authorization", new String[]{"Basic " + Base64.getEncoder().encodeToString((artifactoryConfiguration.getUsername() + ":" + artifactoryConfiguration.getPassword()).getBytes(StandardCharsets.UTF_8))})).bodyValue((Object)(artifactoryConfiguration.getAqlQuery(zonedDateTime) + ".offset(" + (aqlSearchResultsPage == null ? 0 : aqlSearchResultsPage.getRange().getStartPos() + aqlSearchResultsPage.getRange().getEndPos()) + ").limit(10000)")).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(string -> {
            log.error(string);
            return Mono.error((Throwable)new RuntimeException("Failed to query artifactory for LSTs: " + clientResponse.statusCode()));
        })).bodyToMono(AqlSearchResultsPage.class);
    }

    protected Mono<Path> downloadAstAsFileInternal(d d2) {
        return Mono.fromCallable(() -> {
            try {
                return Files.createTempFile("ast", ".jar", new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }).flatMap(path -> DataBufferUtils.write((Publisher)this.downloadAst(this.configuration, d2.b()), (Path)path, (OpenOption[])new OpenOption[0]).then(Mono.fromCallable(() -> {
            if (path.toFile().length() == 0L) {
                throw new RuntimeException("LST file length is zero for " + d2.b());
            }
            return path;
        })).doOnError(throwable -> log.error("Error downloading LST {}", (Object)d2.b(), throwable)));
    }

    private Flux<DataBuffer> downloadAst(ArtifactoryConfiguration artifactoryConfiguration, String string) {
        return this.webClient.get().uri(artifactoryConfiguration.getUrl() + "/{download}", uriBuilder -> uriBuilder.replacePath(artifactoryConfiguration.getUrl().getPath() + "/" + string).build(new Object[0])).header("Authorization", new String[]{"Basic " + Base64.getEncoder().encodeToString((artifactoryConfiguration.getUsername().trim() + ":" + artifactoryConfiguration.getPassword().trim()).getBytes(StandardCharsets.UTF_8))}).retrieve().onStatus(HttpStatusCode::isError, clientResponse -> clientResponse.bodyToMono(String.class).flatMap(string2 -> {
            log.error("WebClient error downloading LST. Response body: {}", string2);
            return Mono.error((Throwable)new RuntimeException("Failed to download artifact " + string + " with status " + clientResponse.statusCode()));
        })).toEntityFlux(DataBuffer.class).flatMapMany(responseEntity -> {
            if (responseEntity.getHeaders().getContentLength() <= 0L || responseEntity.getBody() == null) {
                return Flux.error((Throwable)new IllegalStateException("Artifactory returned no content for " + string + " with status " + responseEntity.getStatusCode()));
            }
            return (Publisher)responseEntity.getBody();
        });
    }
}

