/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.artifacts.storage;

import io.moderne.RepositoryInput;
import io.moderne.dx.artifacts.AstArtifact;
import io.moderne.dx.artifacts.RepositoryAstArtifact;
import java.util.HashSet;
import java.util.Set;

public record RepositoryBuild(RepositoryInput repository, String changeset, String buildId, Long weight, String buildPluginName, String buildPluginVersion, long timestamp, Set<AstArtifact> artifacts) {
    private final RepositoryInput repository;
    private final String changeset;
    private final String buildId;
    private final Long weight;
    private final String buildPluginName;
    private final String buildPluginVersion;
    private final long timestamp;
    private final Set<AstArtifact> artifacts;

    public RepositoryBuild(RepositoryInput repository, String changeset, String buildId, Long weight, String buildPluginName, String buildPluginVersion, long timestamp, Set<AstArtifact> artifacts) {
        this.repository = repository;
        this.changeset = changeset;
        this.buildId = buildId;
        this.weight = weight;
        this.buildPluginName = buildPluginName;
        this.buildPluginVersion = buildPluginVersion;
        this.timestamp = timestamp;
        this.artifacts = artifacts;
    }

    public static RepositoryBuild from(RepositoryAstArtifact repoArtifact) {
        HashSet<AstArtifact> artifacts = new HashSet<AstArtifact>();
        artifacts.add(repoArtifact.astArtifact());
        return new RepositoryBuild(repoArtifact.repository(), repoArtifact.changeset(), repoArtifact.buildId(), repoArtifact.weight(), repoArtifact.buildPluginName(), repoArtifact.buildPluginVersion(), repoArtifact.astArtifact().timestamp(), artifacts);
    }

    public RepositoryBuild withArtifact(AstArtifact astArtifact) {
        HashSet<AstArtifact> newArtifacts = new HashSet<AstArtifact>(this.artifacts);
        newArtifacts.add(astArtifact);
        return new RepositoryBuild(this.repository(), this.changeset(), this.buildId(), this.weight(), this.buildPluginName(), this.buildPluginVersion(), this.timestamp(), newArtifacts);
    }

    public RepositoryInput repository() {
        return this.repository;
    }

    public String changeset() {
        return this.changeset;
    }

    public String buildId() {
        return this.buildId;
    }

    public Long weight() {
        return this.weight;
    }

    public String buildPluginName() {
        return this.buildPluginName;
    }

    public String buildPluginVersion() {
        return this.buildPluginVersion;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Set<AstArtifact> artifacts() {
        return this.artifacts;
    }
}

