/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.config;

import io.moderne.dx.config.ArtifactRepository;
import jakarta.validation.constraints.NotEmpty;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;

public class ArtifactoryConfiguration
implements ArtifactRepository {
    URL url;
    @Nullable
    transient String username;
    @Nullable
    transient String password;
    @NotEmpty(message="Artifactory query must be provided. See https://docs.moderne.io/administrator-documentation/moderne-dx/how-to-guides/configure-dx-with-artifactory-access")
    @NotEmpty(message="Artifactory query must be provided. See https://docs.moderne.io/administrator-documentation/moderne-dx/how-to-guides/configure-dx-with-artifactory-access") List<String> astQueryFilters;
    boolean valid;
    boolean skipSsl;
    boolean skipValidateConnectivity;
    @Nullable
    Boolean recipeSource;

    public boolean isAstSource() {
        return this.astQueryFilters != null;
    }

    public URI getUri() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public boolean isRecipeSource() {
        return this.recipeSource == null || this.recipeSource != false;
    }

    public String getAqlQuery(ZonedDateTime zonedDateTime) {
        assert (this.astQueryFilters != null);
        return "items.find({" + String.join((CharSequence)",", this.astQueryFilters) + ",\"modified\":{\"$gt\":\"" + zonedDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME) + "\"}}).include(\"name\",\"repo\",\"path\",\"modified\")";
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public List<String> getAstQueryFilters() {
        return this.astQueryFilters;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public boolean isSkipSsl() {
        return this.skipSsl;
    }

    @Generated
    public boolean isSkipValidateConnectivity() {
        return this.skipValidateConnectivity;
    }

    @Generated
    public Boolean getRecipeSource() {
        return this.recipeSource;
    }

    @Generated
    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    @Generated
    public void setUsername(String string) {
        this.username = string;
    }

    @Generated
    public void setPassword(String string) {
        this.password = string;
    }

    @Generated
    public void setAstQueryFilters(List<String> list) {
        this.astQueryFilters = list;
    }

    @Generated
    public void setSkipSsl(boolean bl) {
        this.skipSsl = bl;
    }

    @Generated
    public void setSkipValidateConnectivity(boolean bl) {
        this.skipValidateConnectivity = bl;
    }

    @Generated
    public void setRecipeSource(Boolean bl) {
        this.recipeSource = bl;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArtifactoryConfiguration)) {
            return false;
        }
        ArtifactoryConfiguration artifactoryConfiguration = (ArtifactoryConfiguration)object;
        if (!artifactoryConfiguration.canEqual((Object)this)) {
            return false;
        }
        if (this.isValid() != artifactoryConfiguration.isValid()) {
            return false;
        }
        if (this.isSkipSsl() != artifactoryConfiguration.isSkipSsl()) {
            return false;
        }
        if (this.isSkipValidateConnectivity() != artifactoryConfiguration.isSkipValidateConnectivity()) {
            return false;
        }
        Boolean bl = this.getRecipeSource();
        Boolean bl2 = artifactoryConfiguration.getRecipeSource();
        if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
            return false;
        }
        URL uRL = this.getUrl();
        URL uRL2 = artifactoryConfiguration.getUrl();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        List list = this.getAstQueryFilters();
        List list2 = artifactoryConfiguration.getAstQueryFilters();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof ArtifactoryConfiguration;
    }

    @Generated
    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        n3 = n3 * 59 + (this.isValid() ? 79 : 97);
        n3 = n3 * 59 + (this.isSkipSsl() ? 79 : 97);
        n3 = n3 * 59 + (this.isSkipValidateConnectivity() ? 79 : 97);
        Boolean bl = this.getRecipeSource();
        n3 = n3 * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
        URL uRL = this.getUrl();
        n3 = n3 * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        List list = this.getAstQueryFilters();
        n3 = n3 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n3;
    }

    @Generated
    public String toString() {
        return "ArtifactoryConfiguration(url=" + this.getUrl() + ", astQueryFilters=" + this.getAstQueryFilters() + ", valid=" + this.isValid() + ", skipSsl=" + this.isSkipSsl() + ", skipValidateConnectivity=" + this.isSkipValidateConnectivity() + ", recipeSource=" + this.getRecipeSource() + ")";
    }

    @Generated
    public ArtifactoryConfiguration(URL uRL, String string, String string2, List<String> list, boolean bl, boolean bl2, boolean bl3, Boolean bl4) {
        this.url = uRL;
        this.username = string;
        this.password = string2;
        this.astQueryFilters = list;
        this.valid = bl;
        this.skipSsl = bl2;
        this.skipValidateConnectivity = bl3;
        this.recipeSource = bl4;
    }

    @Generated
    public ArtifactoryConfiguration() {
    }

    @Generated
    public void setValid(boolean bl) {
        this.valid = bl;
    }
}

