/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.organization;

import com.jayway.jsonpath.TypeRef;
import com.netflix.graphql.dgs.client.GraphQLError;
import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.WebClientGraphQLClient;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.moderne.RepositoryInput;
import io.moderne.cli.utils.HttpUtils;
import io.moderne.dx.a;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.dx.config.OrganizationConfiguration;
import io.moderne.dx.graphqlclient.types.User;
import io.moderne.dx.organization.OrganizationServiceClient;
import io.moderne.dx.organization.ShallowOrganization;
import io.moderne.dx.types.CommitOption;
import io.moderne.dx.types.Organization;
import io.moderne.dx.types.Repository;
import io.moderne.metrics.ReactorMetrics;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrganizationServiceClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationServiceClient.class);
    static final String ORPHANED_ORGANIZATION = "Orphaned";
    private final WebClient webClient;
    private final DxConfiguration configuration;
    private final AtomicInteger isRepositoriesSupported = new AtomicInteger(-1);
    @Language(value="graphql")
    private static final String USER_TENANT_ORGANIZATIONS_QUERY = "query UserOrganizations($user: User!) {\n          userOrganizations(user: $user) {\n            id\n            name\n            commitOptions\n            parent {\n              id\n              name\n              commitOptions\n          }\n        }\n    }\n";
    @Language(value="graphql")
    private static final String ALL_TENANT_ORGANIZATIONS_QUERY = "query AllOrganizations{\n      allOrganizations {\n        id\n    }\n}\n";
    @Language(value="graphql")
    private static final String TENANT_ORGANIZATION_QUERY = "query Organization($id:ID!, $first: Int, $after: String) {\n  organization(id:$id) {\n    id\n    name\n    commitOptions\n    parent {\n      id\n      name\n      commitOptions\n    }\n    devCenter {\n      upgradesAndMigrations {\n        title\n            measures {\n              name\n              recipe {\n                recipeId\n                options {\n                  name\n                  value\n                }\n              }\n            }\n        }\n        security {\n            name\n            recipeId\n            options {\n                name\n                value\n            }\n        }\n      }\n    repositories(first: $first, after: $after) {\n      pageInfo {\n        hasNextPage\n        startCursor\n        endCursor\n      }\n      edges {\n        node {\n          origin\n          path\n          branch\n        }\n      }\n    }\n  }\n}\n";
    @Language(value="graphql")
    private static final String TENANT_ORGANIZATION_QUERY_WITHOUT_SECURITY_NAME = "query Organization($id:ID!, $first: Int, $after: String) {\n  organization(id:$id) {\n    id\n    name\n    commitOptions\n    parent {\n      id\n      name\n      commitOptions\n    }\n    devCenter {\n      upgradesAndMigrations {\n        title\n            measures {\n              name\n              recipe {\n                recipeId\n                options {\n                  name\n                  value\n                }\n              }\n            }\n        }\n        security {\n            recipeId\n            options {\n                name\n                value\n            }\n        }\n      }\n    repositories(first: $first, after: $after) {\n      pageInfo {\n        hasNextPage\n        startCursor\n        endCursor\n      }\n      edges {\n        node {\n          origin\n          path\n          branch\n        }\n      }\n    }\n  }\n}\n";
    @Language(value="graphql")
    private static final String GRAPHQL_BATCH_ORGANIZATIONS_QUERY = "    %s: organizations(repository: {\n      origin: \"%s\",\n      path: \"%s\",\n      branch: \"%s\"\n    }) {\n      id\n      name\n      commitOptions\n      parent {\n        id\n        name\n        commitOptions\n      }\n      devCenter {\n        upgradesAndMigrations {\n          title\n          measures {\n            name\n            recipe {\n              recipeId\n              options {\n                name\n                value\n              }\n            }\n          }\n        }\n        security {\n          recipeId\n          options {\n            name\n            value\n          }\n        }\n      }\n    }\n";
    @Language(value="graphql")
    private static final String INTROSPECTION_QUERY = "query TypeIntrospection($type: String!) {\n   __type(name: $type) {\n     name\n     fields {\n       name\n     }\n   }\n }\n";

    public OrganizationServiceClient(DxConfiguration dxConfiguration, WebClient.Builder builder) {
        this.configuration = dxConfiguration;
        OrganizationConfiguration organizationConfiguration = dxConfiguration.getOrganization();
        String string = HttpUtils.urlWithPath((URL)organizationConfiguration.getUrl(), (String)"/graphql");
        WebClient.Builder builder2 = builder.clone().baseUrl(string);
        if (organizationConfiguration.isSkipSsl()) {
            a.a((WebClient.Builder)builder2);
        }
        this.webClient = builder2.build();
        Metrics.gauge((String)"moderne.dx.organization.service.graphql.repositories.supported", (Object)this.isRepositoriesSupported, AtomicInteger::get);
    }

    Mono<Boolean> organizationServiceExposesRepositories() {
        return this.typeHasField("Organization", "repositories");
    }

    Mono<Boolean> devCenterRecipeExposesName() {
        return this.typeHasField("DevCenterRecipe", "name");
    }

    Mono<List<ShallowOrganization>> findOrganizationsUserHasAccessTo(String string) {
        return Mono.defer(() -> {
            WebClientGraphQLClient webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)this.webClient);
            return webClientGraphQLClient.reactiveExecuteQuery("query UserOrganizations($user: User!) {\n          userOrganizations(user: $user) {\n            id\n            name\n            commitOptions\n            parent {\n              id\n              name\n              commitOptions\n          }\n        }\n    }\n", Map.of("user", new User(string)));
        }).publishOn(Schedulers.boundedElastic()).flatMapMany(graphQLResponse -> {
            if (!graphQLResponse.getErrors().isEmpty()) {
                return Flux.error((Throwable)new RuntimeException(graphQLResponse.getErrors().toString()));
            }
            return Flux.fromIterable((Iterable)((Iterable)graphQLResponse.extractValueAsObject("userOrganizations", (TypeRef)new /* Unavailable Anonymous Inner Class!! */)));
        }).concatWith((Publisher)Flux.just((Object)new ShallowOrganization("Orphaned", "Orphaned", this.configuration.getOrganization().getDefaultCommitOptions(), null))).collectList().transform(ReactorMetrics.recordMonoMetrics((Timer.Sample)Timer.start(), (Timer.Builder)Timer.builder((String)"moderne.dx.organization.user.repositories"), (LongTaskTimer.Sample)Metrics.more().longTaskTimer("moderne.dx.organization.user.repositories.in.progress", new String[0]).start()));
    }

    Flux<OrganizationWithRepositoryInputs> fetchAllOrganizations() {
        return Mono.defer(() -> {
            WebClientGraphQLClient webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)this.webClient);
            return webClientGraphQLClient.reactiveExecuteQuery("query AllOrganizations{\n      allOrganizations {\n        id\n    }\n}\n");
        }).publishOn(Schedulers.boundedElastic()).flatMapMany(graphQLResponse -> {
            if (!graphQLResponse.getErrors().isEmpty()) {
                return Mono.error((Throwable)new RuntimeException(graphQLResponse.getErrors().toString()));
            }
            List list = (List)graphQLResponse.extractValueAsObject("allOrganizations", (TypeRef)new /* Unavailable Anonymous Inner Class!! */);
            return this.devCenterRecipeExposesName().flatMapMany(bl -> Flux.fromIterable((Iterable)list).flatMapSequential(idHolder -> this.fetchOrganization(idHolder.id, bl.booleanValue())));
        });
    }

    private Mono<OrganizationWithRepositoryInputs> fetchOrganization(String string, boolean bl) {
        return this.fetchPage(string, null, bl).expand(graphQLResponse -> {
            boolean bl2;
            if (!graphQLResponse.getErrors().isEmpty()) {
                return Flux.error((Throwable)new RuntimeException(graphQLResponse.getErrors().toString()));
            }
            io.moderne.dx.graphqlclient.types.Organization organization = (io.moderne.dx.graphqlclient.types.Organization)graphQLResponse.extractValueAsObject("organization", (TypeRef)new /* Unavailable Anonymous Inner Class!! */);
            String string2 = organization.getRepositories().getPageInfo().getEndCursor();
            boolean bl3 = bl2 = organization.getRepositories().getPageInfo().getHasNextPage() && string2 != null;
            if (!bl2) {
                return Mono.empty();
            }
            return this.fetchPage(string, string2, bl);
        }).map(graphQLResponse -> (io.moderne.dx.graphqlclient.types.Organization)graphQLResponse.extractValueAsObject("organization", io.moderne.dx.graphqlclient.types.Organization.class)).collectList().mapNotNull(list -> {
            if (list.isEmpty()) {
                return null;
            }
            LinkedHashSet<RepositoryInput> linkedHashSet = new LinkedHashSet<RepositoryInput>();
            io.moderne.dx.graphqlclient.types.Organization organization = (io.moderne.dx.graphqlclient.types.Organization)list.get(0);
            OrganizationWithRepositoryInputs organizationWithRepositoryInputs = new OrganizationWithRepositoryInputs(organization.getId(), organization.getName(), organization.getCommitOptions().stream().map(Enum::name).map(CommitOption::valueOf).toList(), organization.getParent() == null ? null : organization.getParent().getId(), linkedHashSet, organization.getDevCenter());
            for (io.moderne.dx.graphqlclient.types.Organization organization2 : list) {
                linkedHashSet.addAll(organization2.getRepositories().getEdges().stream().map(repositoryEdge -> new RepositoryInput(repositoryEdge.getNode().getOrigin(), repositoryEdge.getNode().getPath(), repositoryEdge.getNode().getBranch())).toList());
            }
            return organizationWithRepositoryInputs;
        });
    }

    private Mono<GraphQLResponse> fetchPage(String string, String string2, boolean bl) {
        return Mono.defer(() -> {
            WebClientGraphQLClient webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)this.webClient);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("id", string);
            hashMap.put("first", 100);
            hashMap.put("after", string2);
            return webClientGraphQLClient.reactiveExecuteQuery(bl ? "query Organization($id:ID!, $first: Int, $after: String) {\n  organization(id:$id) {\n    id\n    name\n    commitOptions\n    parent {\n      id\n      name\n      commitOptions\n    }\n    devCenter {\n      upgradesAndMigrations {\n        title\n            measures {\n              name\n              recipe {\n                recipeId\n                options {\n                  name\n                  value\n                }\n              }\n            }\n        }\n        security {\n            name\n            recipeId\n            options {\n                name\n                value\n            }\n        }\n      }\n    repositories(first: $first, after: $after) {\n      pageInfo {\n        hasNextPage\n        startCursor\n        endCursor\n      }\n      edges {\n        node {\n          origin\n          path\n          branch\n        }\n      }\n    }\n  }\n}\n" : "query Organization($id:ID!, $first: Int, $after: String) {\n  organization(id:$id) {\n    id\n    name\n    commitOptions\n    parent {\n      id\n      name\n      commitOptions\n    }\n    devCenter {\n      upgradesAndMigrations {\n        title\n            measures {\n              name\n              recipe {\n                recipeId\n                options {\n                  name\n                  value\n                }\n              }\n            }\n        }\n        security {\n            recipeId\n            options {\n                name\n                value\n            }\n        }\n      }\n    repositories(first: $first, after: $after) {\n      pageInfo {\n        hasNextPage\n        startCursor\n        endCursor\n      }\n      edges {\n        node {\n          origin\n          path\n          branch\n        }\n      }\n    }\n  }\n}\n", hashMap);
        }).publishOn(Schedulers.boundedElastic());
    }

    Mono<Map<Repository, List<Organization>>> fetchOrganizationsBatch(Collection<Repository> collection) {
        ArrayList<Repository> arrayList = new ArrayList<Repository>(collection);
        return Mono.defer(() -> {
            WebClientGraphQLClient webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)this.webClient);
            String string = OrganizationServiceClient.buildBatchedOrganizationsQuery((Collection)collection);
            return webClientGraphQLClient.reactiveExecuteQuery(string);
        }).publishOn(Schedulers.boundedElastic()).flatMapMany(graphQLResponse -> {
            if (!graphQLResponse.getErrors().isEmpty()) {
                return Flux.error((Throwable)new RuntimeException(graphQLResponse.getErrors().toString()));
            }
            return Flux.range((int)0, (int)collection.size()).map(n2 -> {
                List list2 = (List)graphQLResponse.extractValueAsObject("r_%s".formatted(n2), (TypeRef)new /* Unavailable Anonymous Inner Class!! */);
                return new RepoOrgs((Repository)arrayList.get((int)n2), list2);
            });
        }).collectMap(RepoOrgs::repository, RepoOrgs::organization);
    }

    private static String buildBatchedOrganizationsQuery(Collection<Repository> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("query {\n");
        AtomicInteger atomicInteger = new AtomicInteger(0);
        collection.stream().map(repository -> "    %s: organizations(repository: {\n      origin: \"%s\",\n      path: \"%s\",\n      branch: \"%s\"\n    }) {\n      id\n      name\n      commitOptions\n      parent {\n        id\n        name\n        commitOptions\n      }\n      devCenter {\n        upgradesAndMigrations {\n          title\n          measures {\n            name\n            recipe {\n              recipeId\n              options {\n                name\n                value\n              }\n            }\n          }\n        }\n        security {\n          recipeId\n          options {\n            name\n            value\n          }\n        }\n      }\n    }\n".formatted("r_%s".formatted(atomicInteger.getAndIncrement()), repository.getOrigin(), repository.getPath(), repository.getBranch())).forEach(stringBuilder::append);
        stringBuilder.append("\n}");
        return stringBuilder.toString();
    }

    private Mono<Boolean> typeHasField(String string, String string2) {
        return Mono.defer(() -> {
            WebClientGraphQLClient webClientGraphQLClient = MonoGraphQLClient.createWithWebClient((WebClient)this.webClient);
            return webClientGraphQLClient.reactiveExecuteQuery("query TypeIntrospection($type: String!) {\n   __type(name: $type) {\n     name\n     fields {\n       name\n     }\n   }\n }\n", Map.of("type", string));
        }).publishOn(Schedulers.boundedElastic()).flatMap(graphQLResponse -> {
            if (!graphQLResponse.getErrors().isEmpty()) {
                for (GraphQLError graphQLError : graphQLResponse.getErrors()) {
                    if (graphQLResponse.getErrors().size() != 1 || !graphQLError.getMessage().contains("is undefined")) continue;
                    return Mono.just((Object)Boolean.FALSE);
                }
                return Mono.error((Throwable)new RuntimeException(graphQLResponse.getErrors().toString()));
            }
            IntrospectionResponse introspectionResponse = (IntrospectionResponse)graphQLResponse.extractValueAsObject("__type", (TypeRef)new /* Unavailable Anonymous Inner Class!! */);
            if (introspectionResponse == null) {
                log.warn("organization-service introspection is not working as expected. Response does not contain __type: {}", graphQLResponse);
            } else {
                for (QueryField queryField : introspectionResponse.fields) {
                    if (!queryField.name.equals(string2)) continue;
                    log.trace("[Introspection] Field {} found for type {}.", (Object)string2, (Object)introspectionResponse.name);
                    return Mono.just((Object)Boolean.TRUE);
                }
            }
            log.trace("[Introspection] Field {} NOT found for type {}\n{}", new Object[]{string2, introspectionResponse.name, introspectionResponse});
            return Mono.just((Object)Boolean.FALSE);
        }).doOnNext(bl -> this.isRepositoriesSupported.set(bl == Boolean.TRUE ? 1 : 0));
    }
}

