/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.organization;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import io.moderne.RepositoryInput;
import io.moderne.dx.artifacts.TypedRepositoryBuilder;
import io.moderne.dx.artifacts.g;
import io.moderne.dx.artifacts.storage.a;
import io.moderne.dx.config.DxConfiguration;
import io.moderne.dx.config.ScmConfiguration;
import io.moderne.dx.organization.OrganizationStructureService;
import io.moderne.dx.organization.OrganizationWithRepositories;
import io.moderne.dx.organization.ReposCsvRow;
import io.moderne.dx.types.CommitOption;
import io.moderne.dx.types.Repository;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.GitRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OrganizationStructureService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OrganizationStructureService.class);
    private final DxConfiguration dxConfiguration;
    private final g repositoryFinder;
    private final TypedRepositoryBuilder typedRepositoryBuilder;
    private final GitRemote.Parser gitRemoteParser;

    public OrganizationStructureService(DxConfiguration dxConfiguration, g g2, TypedRepositoryBuilder typedRepositoryBuilder) {
        this.dxConfiguration = dxConfiguration;
        this.repositoryFinder = g2;
        this.typedRepositoryBuilder = typedRepositoryBuilder;
        this.gitRemoteParser = OrganizationStructureService.buildGitRemoteParser((DxConfiguration)dxConfiguration);
    }

    public Map<String, OrganizationWithRepositories> readOrganizationStructure() {
        LinkedHashMap<String, OrganizationWithRepositories> linkedHashMap = new LinkedHashMap<String, OrganizationWithRepositories>();
        LinkedHashSet<Repository> linkedHashSet = new LinkedHashSet<Repository>();
        File file = Objects.requireNonNull(this.dxConfiguration.getOrganization().getReposCsv()).toAbsolutePath().toFile();
        log.info("Building organization structure from {}", (Object)file);
        CsvMapper csvMapper = new CsvMapper();
        CsvSchema csvSchema = CsvSchema.emptySchema().withHeader().withComments();
        try (MappingIterator mappingIterator = csvMapper.readerFor(ReposCsvRow.class).with((FormatSchema)csvSchema).readValues(file);){
            while (mappingIterator.hasNextValue()) {
                ReposCsvRow reposCsvRow = (ReposCsvRow)mappingIterator.nextValue();
                Repository repository = this.buildRepository(reposCsvRow);
                linkedHashSet.add(repository);
                LinkedList linkedList = new LinkedList(reposCsvRow.getOrganizations());
                if (linkedList.isEmpty()) {
                    throw new IllegalStateException("repos.csv lines should have at least 1 organization");
                }
                boolean bl = true;
                do {
                    String string = (String)linkedList.poll();
                    String string2 = (String)linkedList.peek();
                    OrganizationWithRepositories organizationWithRepositories2 = linkedHashMap.compute(string, (string3, organizationWithRepositories) -> {
                        if (organizationWithRepositories == null) {
                            organizationWithRepositories = new OrganizationWithRepositories(string, string, List.of(CommitOption.values()), string2, new LinkedHashSet());
                        }
                        if (!Objects.equals(organizationWithRepositories.parentId(), string2)) {
                            throw new IllegalStateException("An organization parent must be the same for each repository. %s has parent %s and %s".formatted(string, organizationWithRepositories.parentId(), string2));
                        }
                        return organizationWithRepositories;
                    });
                    if (!bl) continue;
                    bl = false;
                    organizationWithRepositories2.repositories().add(repository);
                } while (!linkedList.isEmpty());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        linkedHashMap.put("ALL", new OrganizationWithRepositories("ALL", "ALL", List.of(CommitOption.values()), null, linkedHashSet));
        this.logStructure(linkedHashMap);
        return linkedHashMap;
    }

    private static GitRemote.Parser buildGitRemoteParser(DxConfiguration dxConfiguration) {
        GitRemote.Parser parser = new GitRemote.Parser();
        if (dxConfiguration.getScm() != null) {
            for (ScmConfiguration scmConfiguration : dxConfiguration.getScm()) {
                GitRemote.Service service = switch (1.$SwitchMap$io$moderne$dx$config$ScmConfiguration$Type[scmConfiguration.getType().ordinal()]) {
                    default -> throw new IncompatibleClassChangeError();
                    case 1 -> GitRemote.Service.GitHub;
                    case 2 -> GitRemote.Service.GitLab;
                    case 3 -> GitRemote.Service.Bitbucket;
                    case 4 -> GitRemote.Service.BitbucketCloud;
                    case 5 -> GitRemote.Service.AzureDevOps;
                };
                parser.registerRemote(service, scmConfiguration.getUrl());
            }
        }
        return parser;
    }

    private Repository buildRepository(ReposCsvRow reposCsvRow) {
        RepositoryInput repositoryInput = this.determineRepositoryInput(reposCsvRow.getCloneUrl(), reposCsvRow.getBranch());
        a a2 = this.repositoryFinder.a(repositoryInput);
        return this.typedRepositoryBuilder.a(repositoryInput, a2);
    }

    RepositoryInput determineRepositoryInput(String string, String string2) {
        GitRemote gitRemote = this.gitRemoteParser.parse(string);
        if (gitRemote.getService() == GitRemote.Service.Unknown) {
            throw new IllegalArgumentException("No matching SCM configuration found and repository does not have a known origin for clone url %s.".formatted(string));
        }
        return new RepositoryInput(gitRemote.getOrigin(), gitRemote.getPath(), string2);
    }

    void logStructure(Map<String, OrganizationWithRepositories> map) {
        HashMap hashMap = new HashMap();
        for (OrganizationWithRepositories organizationWithRepositories : map.values()) {
            if (!hashMap.containsKey(organizationWithRepositories.parentId())) {
                hashMap.put(organizationWithRepositories.parentId(), new ArrayList());
            }
            ((List)hashMap.get(organizationWithRepositories.parentId())).add(organizationWithRepositories);
        }
        if (log.isDebugEnabled()) {
            log.debug("Organization structure loaded from CSV: name [repositories]");
            OrganizationStructureService.printTree(hashMap, null, (int)0);
        }
    }

    public static void printTree(Map<String, List<OrganizationWithRepositories>> map, String string, int n2) {
        for (OrganizationWithRepositories organizationWithRepositories : map.getOrDefault(string, Collections.emptyList())) {
            String string2 = "\t".repeat(n2);
            log.debug("{}{} [{}]", new Object[]{string2, organizationWithRepositories.name(), organizationWithRepositories.repositories().size()});
            OrganizationStructureService.printTree(map, (String)organizationWithRepositories.name(), (int)(n2 + 1));
        }
    }
}

