/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.recipe;

import graphql.execution.DataFetcherResult;
import io.moderne.dx.types.Column;
import io.moderne.dx.types.Contributor;
import io.moderne.dx.types.DataTable;
import io.moderne.dx.types.Maintainer;
import io.moderne.dx.types.Option;
import io.moderne.dx.types.Recipe;
import io.moderne.dx.types.RecipeArtifact;
import io.moderne.dx.types.RecipeCategory;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.CategoryTree;
import org.openrewrite.config.ColumnDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import reactor.core.publisher.Flux;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RecipeMapper {
    private static final DateTimeFormatter SNAPSHOT_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss");

    private RecipeMapper() {
    }

    public static RecipeArtifact mapRecipeArtifact(ResolvedGroupArtifactVersion recipeArtifact) {
        RecipeArtifact.Builder builder = RecipeArtifact.newBuilder().groupId(recipeArtifact.getGroupId()).artifactId(recipeArtifact.getArtifactId()).version(recipeArtifact.getVersion()).repositoryUrl(recipeArtifact.getRepository()).datedSnapshotVersion(recipeArtifact.getDatedSnapshotVersion());
        String dsv = recipeArtifact.getDatedSnapshotVersion();
        if (dsv != null) {
            try {
                builder = builder.datedSnapshotVersion(dsv);
                String dateString = recipeArtifact.getDatedSnapshotVersion().replaceAll("[^-]+-([^-]+)-.*", "$1");
                LocalDateTime dsvAsLocal = SNAPSHOT_DATE_TIME_FORMAT.parse((CharSequence)dateString, LocalDateTime::from);
                builder = builder.snapshotTime(dsvAsLocal.atOffset(ZoneOffset.UTC));
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return builder.build();
    }

    public static Flux<DataFetcherResult<RecipeCategory>> mapCategories(Collection<? extends CategoryTree<?>> categories) {
        return Flux.fromIterable(categories).map(category -> DataFetcherResult.newResult().data((Object)RecipeMapper.mapCategory((CategoryTree)category)).localContext(category).build());
    }

    private static RecipeCategory mapCategory(CategoryTree<?> categoryTree) {
        CategoryDescriptor descriptor = categoryTree.getDescriptor();
        return RecipeCategory.newBuilder().id(descriptor.getPackageName()).name(descriptor.getDisplayName()).description(descriptor.getDescription()).tags(new ArrayList(descriptor.getTags())).totalRecipeCount(categoryTree.getRecipeCount().intValue()).build();
    }

    public static Recipe mapRecipe(RecipeDescriptor recipe) {
        return Recipe.newBuilder().id(recipe.getName()).name(recipe.getDisplayName()).description(recipe.getDescription()).tags(new ArrayList(recipe.getTags())).options(recipe.getOptions().stream().map(RecipeMapper::mapOption).collect(Collectors.toList())).dataTables(recipe.getDataTables().stream().map(RecipeMapper::mapDataTables).collect(Collectors.toList())).recipeList(recipe.getRecipeList().stream().map(RecipeMapper::mapRecipe).collect(Collectors.toList())).totalRecipes(RecipeMapper.recipePipelineSize((RecipeDescriptor)recipe)).timeSavings(recipe.getEstimatedEffortPerOccurrence()).maintainers(recipe.getMaintainers().stream().map(maintainer -> new Maintainer(maintainer.getMaintainer(), maintainer.getLogo() != null ? maintainer.getLogo().toString() : null)).collect(Collectors.toList())).contributors(recipe.getContributors().stream().map(contributor -> new Contributor(contributor.getName(), contributor.getEmail(), contributor.getLineCount())).collect(Collectors.toList())).build();
    }

    private static DataTable mapDataTables(DataTableDescriptor dataTableDescriptor) {
        return new DataTable(dataTableDescriptor.getName(), dataTableDescriptor.getDisplayName(), dataTableDescriptor.getDescription(), dataTableDescriptor.getColumns().stream().map(RecipeMapper::mapColumn).toList());
    }

    private static Option mapOption(OptionDescriptor optionDescriptor) {
        return new Option(optionDescriptor.getName(), optionDescriptor.getType(), optionDescriptor.getDisplayName(), optionDescriptor.getDescription(), optionDescriptor.getExample(), optionDescriptor.getValid(), optionDescriptor.isRequired(), optionDescriptor.getValue());
    }

    private static Column mapColumn(ColumnDescriptor columnDescriptor) {
        return new Column(columnDescriptor.getName(), columnDescriptor.getDisplayName(), columnDescriptor.getDescription(), columnDescriptor.getType());
    }

    private static int recipePipelineSize(RecipeDescriptor recipe) {
        return 1 + recipe.getRecipeList().size() + recipe.getRecipeList().stream().mapToInt(RecipeMapper::recipePipelineSize).sum();
    }
}

