/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.dx.validators.connectivity;

import io.moderne.dx.a;
import io.moderne.dx.config.ArtifactoryConfiguration;
import io.moderne.dx.config.BasicAuthHttpToolConfiguration;
import io.moderne.dx.config.HttpToolConfiguration;
import io.moderne.dx.validators.connectivity.CanConnect;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class HttpToolConnectionValidator
implements ConstraintValidator<CanConnect, HttpToolConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpToolConnectionValidator.class);

    public boolean isValid(HttpToolConfiguration httpToolConfiguration, @Nullable ConstraintValidatorContext constraintValidatorContext) {
        return Boolean.TRUE.equals(this.isCurrentlyValid(httpToolConfiguration, constraintValidatorContext).block());
    }

    public Mono<Boolean> isCurrentlyValid(HttpToolConfiguration httpToolConfiguration, @Nullable ConstraintValidatorContext constraintValidatorContext) {
        if (httpToolConfiguration.isSkipValidateConnectivity()) {
            return Mono.just((Object)true);
        }
        WebClient.Builder builder = WebClient.builder();
        if (httpToolConfiguration.isSkipSsl()) {
            a.a((WebClient.Builder)builder);
        }
        if (httpToolConfiguration instanceof ArtifactoryConfiguration) {
            ArtifactoryConfiguration artifactoryConfiguration = (ArtifactoryConfiguration)httpToolConfiguration;
            return this.isArtifactoryValid(artifactoryConfiguration, constraintValidatorContext, builder);
        }
        if (httpToolConfiguration instanceof BasicAuthHttpToolConfiguration) {
            BasicAuthHttpToolConfiguration basicAuthHttpToolConfiguration = (BasicAuthHttpToolConfiguration)httpToolConfiguration;
            String string = null;
            if (basicAuthHttpToolConfiguration.hasBasicAuthCredentials()) {
                string = basicAuthHttpToolConfiguration.createEncodedBasicAuthHeader();
            }
            return this.canConnectToUrl(basicAuthHttpToolConfiguration.getUrl().toString(), string, constraintValidatorContext, builder);
        }
        return this.canConnectToUrl(httpToolConfiguration.getUrl().toString(), null, constraintValidatorContext, builder);
    }

    public Mono<Boolean> isArtifactoryValid(ArtifactoryConfiguration artifactoryConfiguration, @Nullable ConstraintValidatorContext constraintValidatorContext, WebClient.Builder builder) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)builder.baseUrl(artifactoryConfiguration.getUrl().toString()).build().post().uri("/api/search/aql", new Object[0])).contentType(MediaType.TEXT_PLAIN).headers(httpHeaders -> {
            if (artifactoryConfiguration.getUsername() != null && artifactoryConfiguration.getPassword() != null) {
                httpHeaders.setBasicAuth(artifactoryConfiguration.getUsername().trim(), artifactoryConfiguration.getPassword().trim());
            }
        })).bodyValue((Object)(artifactoryConfiguration.getAqlQuery(ZonedDateTime.of(1983, 12, 5, 0, 0, 0, 0, ZoneId.systemDefault())) + ".offset(0).limit(1)")).retrieve().toBodilessEntity().flatMap(responseEntity -> Mono.just((Object)true)).onErrorResume(throwable -> {
            if (constraintValidatorContext != null) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate("Artifactory connection verification errored with " + throwable.getMessage() + "\nVerify configuration url, credentials, and query").addConstraintViolation();
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private Mono<Boolean> canConnectToUrl(String string, @Nullable String string2, @Nullable ConstraintValidatorContext constraintValidatorContext, WebClient.Builder builder) {
        return builder.baseUrl(string).build().head().headers(httpHeaders -> {
            if (string2 != null) {
                httpHeaders.set("Authorization", string2);
            }
        }).retrieve().toBodilessEntity().flatMap(responseEntity -> Mono.just((Object)true)).onErrorResume(throwable -> {
            WebClientResponseException webClientResponseException;
            String string = throwable.getMessage();
            if (throwable instanceof WebClientResponseException && ((webClientResponseException = (WebClientResponseException)throwable).getStatusCode().is5xxServerError() || webClientResponseException.getStatusCode().equals(HttpStatus.UNAUTHORIZED) || webClientResponseException.getStatusCode().equals(HttpStatus.FORBIDDEN))) {
                string = webClientResponseException.getStatusText();
            } else if (throwable instanceof WebClientResponseException) {
                return Mono.just((Object)true);
            }
            if (constraintValidatorContext != null) {
                constraintValidatorContext.disableDefaultConstraintViolation();
                constraintValidatorContext.buildConstraintViolationWithTemplate("Connection verification errored with " + string + "\n\tVerify configuration url and credentials.").addConstraintViolation();
                return Mono.just((Object)false);
            }
            return Mono.error((Throwable)throwable);
        });
    }
}

