/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import io.moderne.serialization.JavaTypeVariants;
import io.moderne.serialization.m;
import io.moderne.serialization.n;
import io.moderne.serialization.o;
import io.moderne.serialization.q;
import io.moderne.serialization.t;
import io.moderne.serialization.w;
import io.moderne.serialization.z;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.Nullable;
import org.slf4j.LoggerFactory;

public class TreeSerializer {
    private boolean a;
    private ObjectMapper b;
    @Nullable
    private final ClassLoader c;
    private final MeterRegistry d;
    private final z e;

    public TreeSerializer() {
        this(new JavaTypeVariants(), (MeterRegistry)new SimpleMeterRegistry());
    }

    public TreeSerializer(JavaTypeVariants javaTypeVariants, MeterRegistry meterRegistry) {
        this(javaTypeVariants, meterRegistry, null);
    }

    public TreeSerializer(JavaTypeVariants javaTypeVariants, MeterRegistry meterRegistry, @Nullable ClassLoader classLoader) {
        this.d = meterRegistry;
        this.c = classLoader;
        this.e = new z(javaTypeVariants);
        this.b = this.a(classLoader);
    }

    public static void main(String[] object) {
        LoggerFactory.getLogger(TreeSerializer.class).info("Starting");
        try {
            if (object[0].endsWith(".jar")) {
                object = new TreeSerializer().readJar(Paths.get(object[0], new String[0]));
            } else {
                try (FileInputStream fileInputStream = new FileInputStream(object[0]);){
                    object = new TreeSerializer().read(fileInputStream);
                }
            }
            LoggerFactory.getLogger(TreeSerializer.class).info("Deserialized " + object.size() + " source files");
            return;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        catch (CompressorException compressorException) {
            throw new RuntimeException(compressorException);
        }
    }

    public Collection<SourceFile> readJar(Path object) {
        ArrayList<SourceFile> arrayList = new ArrayList<SourceFile>();
        object = new JarFile(object.toFile());
        try {
            ((JarFile)object).stream().filter(jarEntry -> jarEntry.getName().endsWith(".ast")).forEach(arg_0 -> this.a((JarFile)object, arrayList, arg_0));
            return arrayList;
        }
        finally {
            ((ZipFile)object).close();
        }
    }

    public List<SourceFile> read(InputStream inputStream) {
        List<SourceFile> list;
        block8: {
            inputStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
            try {
                List<SourceFile> list2 = (List<SourceFile>)this.b.readValue(inputStream, (TypeReference)new n(this));
                list2 = new m().a(list2);
                Counter.builder((String)"moderne.ast.load").tags(new String[]{"outcome", "success"}).register(this.d).increment();
                list = list2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    Counter.builder((String)"moderne.ast.load").tags(new String[]{"outcome", "failure", "exception", throwable3.getClass().getName()}).register(this.d).increment();
                    throw throwable3;
                }
            }
            inputStream.close();
        }
        return list;
    }

    public void write(List<?> list, OutputStream outputStream) {
        try (XZCompressorOutputStream xZCompressorOutputStream = new XZCompressorOutputStream((OutputStream)new BufferedOutputStream(outputStream), 3);){
            try {
                List<SourceFile> list2 = list;
                list = this.e;
                list2 = z.a(list2);
                list2 = z.b(list2);
                list2 = z.c(list2);
                list2 = ((z)((Object)list)).d(list2);
                list2 = z.e(list2);
                list = list2;
                if (this.a) {
                    this.b.writerWithDefaultPrettyPrinter().writeValue(outputStream, list);
                } else {
                    this.b.writeValue((OutputStream)xZCompressorOutputStream, list);
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            return;
        }
    }

    public TreeSerializer setPretty(boolean bl) {
        this.a = bl;
        this.b = this.a(this.c);
        return this;
    }

    private ObjectMapper a(@Nullable ClassLoader classLoader) {
        JsonMapper.Builder builder;
        if (this.a) {
            builder = JsonMapper.builder();
        } else {
            builder = new SmileFactory();
            builder.configure(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES, true);
            builder = JsonMapper.builder((JsonFactory)builder);
        }
        builder = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)builder.constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build()).registerModule((Module)new q()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new t()).registerModule((Module)new w()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new o(0)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        builder.coercionConfigFor(LogicalType.Collection).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull).setAcceptBlankAsEmpty(Boolean.TRUE);
        if (classLoader != null) {
            builder.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(classLoader));
        }
        JsonMapper.Builder builder2 = builder;
        return builder2.setVisibility(builder2.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public ObjectMapper getMapper() {
        return this.b;
    }

    private /* synthetic */ void a(JarFile closeable, List list, JarEntry jarEntry) {
        try {
            block9: {
                block8: {
                    closeable = ((JarFile)closeable).getInputStream(jarEntry);
                    try {
                        list.addAll(this.read((InputStream)closeable));
                        if (closeable == null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (closeable != null) {
                            try {
                                ((InputStream)closeable).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block9;
                }
                return;
            }
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Unable to read ast file: " + jarEntry, iOException);
        }
        catch (CompressorException compressorException) {
            throw new RuntimeException("Unable to read ast file: " + jarEntry, compressorException);
        }
    }
}

