/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.ModerneLargeSourceSet$Edit;
import io.moderne.serialization.TreeSerializer;
import io.moderne.serialization.b;
import io.moderne.serialization.b.a;
import io.moderne.serialization.d;
import io.moderne.serialization.e;
import io.moderne.serialization.f;
import io.moderne.serialization.g;
import io.moderne.serialization.h;
import io.moderne.serialization.i;
import io.moderne.serialization.j;
import io.moderne.serialization.k;
import io.moderne.serialization.m;
import io.moderne.serialization.n;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.openrewrite.Changeset;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Recipe;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.Marker;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.tree.Xml;

public class ModerneLargeSourceSet
implements LargeSourceSet {
    public static final int SEGMENT_SIZE = 200;
    private final TreeSerializer a;
    private final Map<String, List<File>> b;
    private final Map<String, List<File>> c;
    private final Path d;
    private final ObjectMapper e;
    private final int f;
    @Nullable
    private List<File> g;
    @Nullable
    private Integer h;
    @Nullable
    private List<File> i;
    @Nullable
    private Integer j;
    @Nullable
    private List<Recipe> k;
    private Path l;
    private int m;
    @Nullable
    private Map<Class<? extends Tree>, NamedStyles> n;
    private final Map<b, n> o = new d(this);
    private static final Timer p = Timer.builder((String)"moderne.lss.extract.fragment.read").register((MeterRegistry)Metrics.globalRegistry);
    private static final DistributionSummary q = DistributionSummary.builder((String)"moderne.lss.extract.fragment.size").register((MeterRegistry)Metrics.globalRegistry);
    private static final Timer r = Timer.builder((String)"moderne.lss.edit").register((MeterRegistry)Metrics.globalRegistry);
    private static final Timer s = Timer.builder((String)"moderne.lss.generate").register((MeterRegistry)Metrics.globalRegistry);
    private static final Timer t = Timer.builder((String)"moderne.lss.load.edit.page").register((MeterRegistry)Metrics.globalRegistry);

    public ModerneLargeSourceSet(@Nullable ClassLoader classLoader, Path path, Path path2) {
        this(classLoader, path, path2, 0);
    }

    public ModerneLargeSourceSet(@Nullable ClassLoader fileArray, Path path, Path path2, int n2) {
        ObjectMapper objectMapper = ((JsonMapper)JsonMapper.builder((JsonFactory)new SmileFactory()).build()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)new io.moderne.serialization.a.a(false)).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper = objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        if (fileArray != null) {
            objectMapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader((ClassLoader)fileArray));
        }
        this.e = objectMapper;
        this.f = n2;
        this.a = new TreeSerializer((MeterRegistry)Metrics.globalRegistry, (ClassLoader)fileArray, false);
        this.d = path2;
        fileArray = Collectors.groupingBy(file -> {
            int n2 = file.getName().indexOf(45);
            if (n2 < 0) {
                return "0";
            }
            return file.getName().substring(0, n2);
        });
        this.b = (Map)Arrays.stream(Objects.requireNonNull(path.toFile().listFiles(file -> file.getName().endsWith(".lst") || file.getName().endsWith(".ast")))).collect(fileArray);
        this.c = (Map)Arrays.stream(Objects.requireNonNull(path.toFile().listFiles(file -> file.getName().endsWith(".styles")))).collect(fileArray);
        fileArray = path2.toFile().listFiles(file -> file.getName().endsWith(".map") && file.getName().startsWith("errors-"));
        if (fileArray != null && fileArray.length > 0) {
            this.g = new ArrayList<File>(fileArray.length);
            Collections.addAll(this.g, fileArray);
            this.g.sort(Comparator.comparing(File::getName));
        }
        if ((fileArray = path2.toFile().listFiles(file -> file.getName().endsWith(".map") && file.getName().startsWith("edits-"))) != null && fileArray.length > 0) {
            this.i = new ArrayList<File>(fileArray.length);
            Collections.addAll(this.i, fileArray);
            this.i.sort(Comparator.comparing(File::getName));
        }
        this.l = path2.resolve("sources.count");
        if (Files.exists(this.l, new LinkOption[0])) {
            try {
                this.m = Integer.parseInt(new String(Files.readAllBytes(this.l)));
                return;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
    }

    public static void extract(List<File> list, File file, OpenOption ... openOptionArray) {
        TreeSerializer treeSerializer = new TreeSerializer(false);
        if (openOptionArray.length == 0) {
            openOptionArray = new OpenOption[]{StandardOpenOption.CREATE};
        }
        if (file.exists()) {
            if (ModerneLargeSourceSet.a(openOptionArray, StandardOpenOption.CREATE_NEW)) {
                throw new IllegalStateException("LST directory " + file + " already exists.");
            }
            if (ModerneLargeSourceSet.a(openOptionArray, StandardOpenOption.TRUNCATE_EXISTING) && !file.delete()) {
                throw new IllegalStateException("Unable to delete LST directory " + file);
            }
            if (ModerneLargeSourceSet.a(openOptionArray, StandardOpenOption.CREATE)) {
                return;
            }
        }
        if (!file.mkdirs()) {
            throw new IllegalStateException("Unable to create LST directory " + file);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n2 = 0;
            int n3 = 0;
            Object object = list.get(i2);
            object = new JarFile((File)object);
            try {
                Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                while (enumeration.hasMoreElements()) {
                    Object object2;
                    Object object3 = enumeration.nextElement();
                    if (((ZipEntry)object3).getName().endsWith(".lst") || ((ZipEntry)object3).getName().endsWith(".ast")) {
                        try {
                            object3 = ((JarFile)object).getInputStream((ZipEntry)object3);
                            try {
                                int n4;
                                Object object4;
                                int n5 = n2;
                                int n6 = i2;
                                List<SourceFile> list2 = object3;
                                object2 = treeSerializer;
                                Comparable<File> comparable = file;
                                Timer.Sample sample = Timer.start();
                                list2 = ((TreeSerializer)object2).read((InputStream)((Object)list2));
                                sample.stop(p);
                                q.record((double)list2.size());
                                sample = Timer.start();
                                String string = list2.size() <= 200 ? "small" : (list2.size() <= 1000 ? "medium" : (list2.size() <= 10000 ? "large" : "xlarge"));
                                string = Timer.builder((String)"moderne.lss.extract.fragment.write").tag("size", string).register((MeterRegistry)Metrics.globalRegistry);
                                if (list2.size() < 200) {
                                    object4 = n6 + "-" + n5 + ".lst";
                                    comparable = ((File)comparable).toPath().resolve((String)object4);
                                    ((TreeSerializer)object2).write(list2, null, comparable.toFile(), new CompressionAlgorithm[0]);
                                    sample.stop((Timer)string);
                                    n4 = n5 + 1;
                                } else {
                                    object4 = new AtomicInteger(n5);
                                    ((TreeSerializer)object2).write(list2.stream(), ((File)comparable).toPath(), () -> ModerneLargeSourceSet.a(n6, (AtomicInteger)object4), new CompressionAlgorithm[0]);
                                    sample.stop((Timer)string);
                                    n4 = ((AtomicInteger)object4).get();
                                }
                                n2 = n4;
                                continue;
                            }
                            finally {
                                if (object3 == null) continue;
                                ((InputStream)object3).close();
                                continue;
                            }
                        }
                        catch (CompressorException compressorException) {
                            throw new RuntimeException(compressorException);
                        }
                    }
                    if (!((ZipEntry)object3).getName().endsWith(".styles")) continue;
                    object3 = ((JarFile)object).getInputStream((ZipEntry)object3);
                    try {
                        object2 = i2 + "-" + n3++ + ".styles";
                        Files.copy(object3, file.toPath().resolve((String)object2), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    }
                    finally {
                        if (object3 == null) continue;
                        ((InputStream)object3).close();
                    }
                }
                continue;
            }
            finally {
                ((ZipFile)object).close();
            }
        }
    }

    private static boolean a(OpenOption[] openOptionArray, OpenOption openOption) {
        for (OpenOption openOption2 : openOptionArray) {
            if (openOption2 != openOption) continue;
            return true;
        }
        return false;
    }

    public void setRecipe(List<Recipe> list) {
        this.k = list;
    }

    public void beforeCycle() {
        this.m = 0;
        this.o.clear();
    }

    public ModerneLargeSourceSet generate(@Nullable Collection<? extends SourceFile> object) {
        if (object == null || object.isEmpty()) {
            return this;
        }
        Timer.Sample sample = Timer.start();
        m m2 = new m();
        m m3 = new m();
        if (this.g == null) {
            this.g = new ArrayList<File>();
        }
        if (this.i == null) {
            this.i = new ArrayList<File>();
        }
        object = object.iterator();
        while (object.hasNext()) {
            SourceFile sourceFile = (SourceFile)object.next();
            boolean bl = this.a(sourceFile);
            m m4 = bl ? m2 : m3;
            m4.a(new i(sourceFile.getSourcePath().toString(), -1), sourceFile);
            this.a(m4, bl ? this.g : this.i, bl);
        }
        this.b(m2, this.g, true);
        this.b(m3, this.i, true);
        sample.stop(s);
        return this;
    }

    public ModerneLargeSourceSet edit(UnaryOperator<SourceFile> unaryOperator) {
        Timer.Sample sample = Timer.start();
        m m2 = new m();
        m m3 = new m();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            ModerneLargeSourceSet moderneLargeSourceSet = this;
            k k2 = new k(moderneLargeSourceSet, moderneLargeSourceSet.g);
            ModerneLargeSourceSet$Edit moderneLargeSourceSet$Edit = this.a(unaryOperator, k2, m2, arrayList, true);
            ModerneLargeSourceSet moderneLargeSourceSet2 = this;
            k k3 = new k(moderneLargeSourceSet2, moderneLargeSourceSet2.i);
            ModerneLargeSourceSet$Edit moderneLargeSourceSet$Edit2 = this.a(unaryOperator, k3, m3, arrayList2, false);
            for (Map.Entry<String, List<File>> entry : this.b.entrySet()) {
                List<File> list = entry.getValue();
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    try (InputStream inputStream = Files.newInputStream(list.get(i2).toPath(), new OpenOption[0]);){
                        Object object2 = this.a.read(inputStream);
                        for (Object object2 : object2) {
                            SourceFile sourceFile;
                            boolean bl;
                            ++this.m;
                            object2 = this.a(entry.getKey(), (SourceFile)object2);
                            boolean bl2 = moderneLargeSourceSet$Edit2 != null && object2.getId().equals(moderneLargeSourceSet$Edit2.getBeforeId());
                            boolean bl3 = bl = moderneLargeSourceSet$Edit != null && object2.getId().equals(moderneLargeSourceSet$Edit.getBeforeId());
                            if (bl2 || bl) {
                                sourceFile = bl2 ? moderneLargeSourceSet$Edit2.getAfter() : moderneLargeSourceSet$Edit.getAfter();
                                if (sourceFile != null) {
                                    sourceFile = (SourceFile)unaryOperator.apply(sourceFile);
                                }
                            } else {
                                sourceFile = (SourceFile)unaryOperator.apply((SourceFile)object2);
                            }
                            if (sourceFile == null) {
                                m3.a(new h(object2.getId(), object2.getSourcePath().toString(), entry.getKey(), i2, Collections.singletonList(this.k)), null);
                                this.a(m3, arrayList2, false);
                            } else {
                                m m4;
                                boolean bl4;
                                boolean bl5 = bl4 = bl || this.a(sourceFile);
                                if (sourceFile != object2) {
                                    UUID uUID = object2.getId();
                                    String string = object2.getSourcePath().toString();
                                    SourceFile sourceFile2 = sourceFile;
                                    m4 = object2;
                                    object2 = this;
                                    m4 = new Result((SourceFile)m4, sourceFile2);
                                    object2 = m4.diff(Paths.get("", new String[0]), new f((ModerneLargeSourceSet)object2));
                                    object2 = new j(uUID, string, sourceFile.getSourcePath().toString(), m3.c().size(), entry.getKey(), i2, object2.isEmpty());
                                } else if (bl2) {
                                    object2 = moderneLargeSourceSet$Edit2;
                                } else {
                                    if (!bl) continue;
                                    object2 = moderneLargeSourceSet$Edit;
                                }
                                m4 = bl4 ? m2 : m3;
                                m4.a((ModerneLargeSourceSet$Edit)object2, sourceFile);
                                this.a(m4, bl4 ? arrayList : arrayList2, bl4);
                            }
                            if (bl2) {
                                moderneLargeSourceSet$Edit2 = k3.hasNext() ? k3.a() : null;
                                continue;
                            }
                            if (!bl) continue;
                            moderneLargeSourceSet$Edit = k2.hasNext() ? k2.a() : null;
                        }
                        continue;
                    }
                }
            }
            this.g = this.a(m2, arrayList, this.g, true);
            this.h = m2.b().size();
            this.i = this.a(m3, arrayList2, this.i, false);
            this.j = m3.b().size();
            Files.write(this.l, Integer.toString(this.m).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException | CompressorException throwable) {
            throw new RuntimeException(throwable);
        }
        finally {
            sample.stop(r);
        }
        return this;
    }

    public void afterCycle(boolean bl) {
        if (bl) {
            this.getChangeset();
        }
    }

    @Nullable
    private ModerneLargeSourceSet$Edit a(UnaryOperator<SourceFile> unaryOperator, k k2, m m2, List<File> list, boolean bl) {
        ModerneLargeSourceSet$Edit moderneLargeSourceSet$Edit;
        ModerneLargeSourceSet$Edit moderneLargeSourceSet$Edit2 = moderneLargeSourceSet$Edit = k2.hasNext() ? k2.a() : null;
        while (moderneLargeSourceSet$Edit instanceof i) {
            SourceFile sourceFile = (SourceFile)unaryOperator.apply(moderneLargeSourceSet$Edit.getAfter());
            m2.a(moderneLargeSourceSet$Edit, sourceFile);
            this.a(m2, list, bl);
            moderneLargeSourceSet$Edit = k2.hasNext() ? k2.a() : null;
        }
        return moderneLargeSourceSet$Edit;
    }

    private List<File> a(m object, List<File> list, @Nullable List<File> object2, boolean bl) {
        this.b((m)object, list, bl);
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object2 = (File)object.next();
                File file = ((File)object2).toPath().resolveSibling(((File)object2).getName().replace(".map", ".lst")).toFile();
                if (((File)object2).delete() && file.delete()) continue;
                throw new RuntimeException("Unable to delete edit file " + object2);
            }
        }
        return list;
    }

    private boolean a(SourceFile sourceFile) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        new e(this, atomicBoolean).visit((Tree)sourceFile, 0);
        return atomicBoolean.get();
    }

    private SourceFile a(String iterator, SourceFile sourceFile) {
        if (this.c.isEmpty()) {
            return sourceFile;
        }
        if (this.n == null) {
            this.n = new HashMap<Class<? extends Tree>, NamedStyles>();
            for (File file : this.c.getOrDefault(iterator, Collections.emptyList())) {
                NamedStyles serializable = this.a.readStyles(file);
                switch (serializable.getName()) {
                    case "org.openrewrite.java.Autodetect": {
                        this.n.put(JavaSourceFile.class, serializable);
                        break;
                    }
                    case "org.openrewrite.xml.Autodetect": {
                        this.n.put(Xml.Document.class, serializable);
                    }
                }
            }
        }
        for (Class clazz : this.n.keySet()) {
            if (!clazz.isAssignableFrom(sourceFile.getClass())) continue;
            SourceFile sourceFile2 = sourceFile;
            sourceFile = (SourceFile)sourceFile2.withMarkers(sourceFile2.getMarkers().add((Marker)this.n.get(clazz)));
        }
        return sourceFile;
    }

    public Changeset getChangeset() {
        return this.getChangeset(new b(null, null));
    }

    public Changeset getChangeset(b b3) {
        return this.o.computeIfAbsent(b3, b2 -> new n(this, (b)b2));
    }

    private void a(m m2, List<File> list, boolean bl) {
        if (m2.c().size() >= 200) {
            this.b(m2, list, bl);
            m2.a();
        }
    }

    private void b(m object, List<File> list, boolean bl) {
        if (((m)object).b().isEmpty()) {
            return;
        }
        List<ModerneLargeSourceSet$Edit> list2 = ((m)object).b();
        Object object2 = new a();
        object = ListUtils.map(((m)object).c(), (arg_0, arg_1) -> ModerneLargeSourceSet.a(list2, (a)((Object)object2), arg_0, arg_1));
        if (list2.isEmpty()) {
            return;
        }
        Object object3 = (bl ? "errors-" : "edits-") + System.nanoTime();
        object2 = this.d.resolve((String)object3 + ".map").toFile();
        object3 = this.d.resolve((String)object3 + ".lst").toFile();
        try {
            this.e.writeValue((File)object2, list2);
            this.a.write((List<SourceFile>)object, null, (File)object3, new CompressionAlgorithm[0]);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        list.add((File)object2);
    }

    private Integer a(@Nullable Integer object, @Nullable List<File> list) {
        if (object == null) {
            if (list == null || list.isEmpty()) {
                object = 0;
            } else {
                try {
                    List<File> list2 = list;
                    object = (List)this.e.readValue(list2.get(list2.size() - 1), (TypeReference)new g(this));
                    object = object.size();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
        return object;
    }

    public int getSourceFileCount() {
        return this.m;
    }

    private static /* synthetic */ SourceFile a(List list, a a2, Integer n2, SourceFile sourceFile) {
        if (list.get(n2) instanceof i) {
            return (SourceFile)a2.visitNonNull((Tree)sourceFile, 0);
        }
        return sourceFile;
    }

    private static /* synthetic */ String a(int n2, AtomicInteger atomicInteger) {
        return n2 + "-" + atomicInteger.getAndIncrement() + ".lst";
    }

    static /* synthetic */ List a(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.g;
    }

    static /* synthetic */ int b(ModerneLargeSourceSet moderneLargeSourceSet) {
        v0.h = moderneLargeSourceSet.a(moderneLargeSourceSet.h, moderneLargeSourceSet.g);
        return moderneLargeSourceSet.h;
    }

    static /* synthetic */ List c(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.i;
    }

    static /* synthetic */ int d(ModerneLargeSourceSet moderneLargeSourceSet) {
        v0.j = moderneLargeSourceSet.a(moderneLargeSourceSet.j, moderneLargeSourceSet.i);
        return moderneLargeSourceSet.j;
    }

    static /* synthetic */ int e(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.f;
    }

    static /* synthetic */ ObjectMapper f(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.e;
    }

    static /* synthetic */ Map g(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.b;
    }

    static /* synthetic */ TreeSerializer h(ModerneLargeSourceSet moderneLargeSourceSet) {
        return moderneLargeSourceSet.a;
    }

    static /* synthetic */ Timer a() {
        return t;
    }
}

