/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.moderne.maven.MeterRegistryProvider;
import io.moderne.maven.ModerneJarLstMojo;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.TreeSerializer;
import io.moderne.serialization.bloom.Bloom;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;

@Mojo(name="compileLst", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ModerneCompileLstMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RuntimeInformation runtime;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="moderne.lstOutputDirectory", defaultValue="${project.build.directory}/moderne/lst", required=true)
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File finalOutputDirectory;
        if (this.runPerSubmodule) {
            this.getLog().info((CharSequence)"We are ignoring the runPerSubmodule in the compileLst goal.");
        }
        if (!(finalOutputDirectory = this.mavenSession.getUserProperties().containsKey("moderne.lstOutputDirectory") || this.mavenSession.getSystemProperties().containsKey("moderne.lstOutputDirectory") ? this.outputDirectory : new File(this.mavenSession.getTopLevelProject().getBuild().getDirectory(), "moderne/lst")).exists() && !finalOutputDirectory.mkdirs()) {
            throw new MojoFailureException("Output directory for LST files does not exist and cannot be created: " + finalOutputDirectory.getAbsolutePath());
        }
        Stream<SourceFile> asts = this.listAsts();
        AtomicLong weight = new AtomicLong();
        Bloom bloom = Bloom.construct(new long[0], 1.0);
        asts = asts.peek(sourceFile -> weight.addAndGet(sourceFile.getWeight(t2 -> {
            int id = System.identityHashCode(t2);
            if (bloom.mayContain(id)) {
                return false;
            }
            bloom.add(id);
            return true;
        })));
        Path lstFolder = this.getLSTFolder();
        Path lstOutputDirectory = lstFolder == null ? finalOutputDirectory.toPath() : finalOutputDirectory.toPath().resolve(lstFolder);
        this.getLog().info((CharSequence)("Writing LST files to " + lstOutputDirectory));
        TreeSerializer.builder().build().write(asts, lstOutputDirectory, new CompressionAlgorithm[0]);
        try (OutputStream os = Files.newOutputStream(lstOutputDirectory.resolve("project.properties"), new OpenOption[0]);){
            Properties properties = new Properties();
            properties.put("weight", Long.toString(weight.get()));
            properties.put("gradleProjectName", this.project.getName());
            ModerneJarLstMojo.addModernePluginProperties(properties);
            properties.store(os, null);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        this.getLog().info((CharSequence)("Wrote LST files to " + finalOutputDirectory.getAbsolutePath()));
    }

    private Path getParentFolder() throws IOException {
        MavenProject parent = this.project;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent.getBasedir().getCanonicalFile().toPath();
    }

    private Path getLSTFolder() throws MojoExecutionException {
        try {
            Path moduleDir = this.project.getExecutionProject().getBasedir().getCanonicalFile().toPath();
            Path baseDir = this.mavenSession.getTopLevelProject().getBasedir().getCanonicalFile().toPath();
            if (baseDir.equals(moduleDir)) {
                return null;
            }
            return baseDir.relativize(moduleDir);
        }
        catch (Exception e2) {
            throw new MojoExecutionException("Unable to resolve LST folder", e2);
        }
    }

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getExecutionProject().getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getExecutionProject().getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getExecutionProject().getProperties()));
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e2);
            }
        }
        return env.build();
    }

    ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t2 -> this.getLog().debug(t2));
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected Stream<SourceFile> listAsts() throws MojoExecutionException {
        MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);
        try {
            Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
            Path baseDir = this.project.getExecutionProject().getBasedir().toPath();
            Environment env = this.environment();
            List styles = this.loadStyles(this.project.getExecutionProject(), env);
            MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, (Collection)this.getExclusions(), (Collection)this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter, true);
            ExecutionContext ctx = this.executionContext();
            Stream<SourceFile> sourceFiles = projectParser.listSourceFiles(this.project.getExecutionProject(), styles, ctx);
            Path relativeFolder = this.getLSTFolder();
            if (relativeFolder != null) {
                sourceFiles = sourceFiles.map(sourceFile -> sourceFile.withSourcePath(relativeFolder.resolve(sourceFile.getSourcePath())));
            }
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            Stream<SourceFile> stream = sourceFiles;
            meterRegistryProvider.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    meterRegistryProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DependencyResolutionRequiredException e2) {
                throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e2));
            }
        }
    }
}

