/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.moderne.maven.MeterRegistryProvider;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.OriginHelper;
import io.moderne.serialization.TreeSerializer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;

@Mojo(name="jarLst", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ModerneJarLstMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RuntimeInformation runtime;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="organization")
    private String organization;
    @Parameter(property="repository")
    private String repository;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String finalArtifactName;
        File finalOutputDirectory;
        List projects = this.mavenSession.getProjects();
        if (this.project.getId().equals(((MavenProject)projects.get(0)).getId())) {
            this.writeBuildId();
        }
        if (!this.runPerSubmodule && !this.project.getId().equals(((MavenProject)projects.get(projects.size() - 1)).getId())) {
            return;
        }
        if (this.runPerSubmodule) {
            finalOutputDirectory = this.outputDirectory;
            finalArtifactName = this.finalName + "-ast.jar";
        } else {
            MavenProject topLevelProject = this.mavenSession.getTopLevelProject();
            finalOutputDirectory = new File(topLevelProject.getBuild().getDirectory());
            finalArtifactName = topLevelProject.getArtifactId() + '-' + topLevelProject.getVersion() + "-ast.jar";
        }
        File astJarFile = new File(finalOutputDirectory, finalArtifactName);
        if (astJarFile.exists()) {
            if (!astJarFile.delete()) {
                throw new MojoFailureException("Unable to overwrite AST jar file: " + astJarFile.getAbsolutePath());
            }
        } else if (!finalOutputDirectory.exists() && !finalOutputDirectory.mkdirs()) {
            throw new MojoFailureException("Output directory for AST file does not exist and cannot be created: " + finalOutputDirectory.getAbsolutePath());
        }
        Stream<SourceFile> asts = this.listAsts();
        try (OutputStream outputStream = Files.newOutputStream(astJarFile.toPath(), new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
             JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);){
            Path tempDirWithPrefix = Files.createTempDirectory("moderne-lst", new FileAttribute[0]);
            TreeSerializer.builder().build().write(asts, tempDirWithPrefix, new CompressionAlgorithm[0]);
            Files.walk(tempDirWithPrefix, new FileVisitOption[0]).filter(p2 -> !Files.isDirectory(p2, new LinkOption[0])).forEach(p2 -> {
                try {
                    jarOutputStream.setLevel(p2.getFileName().endsWith(".lst") ? 0 : -1);
                    jarOutputStream.putNextEntry(new JarEntry(tempDirWithPrefix.relativize((Path)p2).toString()));
                    Files.copy(p2, jarOutputStream);
                    jarOutputStream.closeEntry();
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            });
            jarOutputStream.setLevel(-1);
            jarOutputStream.putNextEntry(new JarEntry("scm.properties"));
            Properties scmProvenance = this.getScmProvenanceProps();
            scmProvenance.store(jarOutputStream, null);
            jarOutputStream.closeEntry();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.getLog().info((CharSequence)("AST jar file written to " + astJarFile.getAbsolutePath()));
        this.projectHelper.attachArtifact(this.project, "jar", "ast", astJarFile);
    }

    private void writeBuildId() {
        Path buildIdPath = this.project.getBasedir().toPath().resolve("target/moderne/buildId.txt");
        try {
            Files.createDirectories(buildIdPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(buildIdPath, new OpenOption[0]);){
                String buildId = UUID.randomUUID().toString();
                writer.write(buildId);
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private String getBuildId() {
        String string;
        block8: {
            MavenProject firstSessionProject = (MavenProject)this.mavenSession.getProjects().get(0);
            Path buildIdPath = firstSessionProject.getBasedir().toPath().resolve("target/moderne/buildId.txt");
            BufferedReader reader = Files.newBufferedReader(buildIdPath);
            try {
                string = reader.readLine();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            reader.close();
        }
        return string;
    }

    private Properties getScmProvenanceProps() throws MojoFailureException {
        Properties scmProperties = new Properties();
        GitProvenance gitProvenance = GitProvenance.fromProjectDirectory((Path)this.getBaseDir(), (BuildEnvironment)BuildEnvironment.build(System::getenv));
        scmProperties.setProperty("buildId", this.getBuildId());
        scmProperties.setProperty("lstFormatVersion", "2");
        if (gitProvenance == null) {
            if (this.organization == null || this.repository == null) {
                throw new MojoFailureException("Organization and repository parameters are required for projects that are not git repositories.");
            }
            scmProperties.setProperty("path", this.organization + "/" + this.repository);
        } else {
            String origin = gitProvenance.getOrigin();
            scmProperties.setProperty("cloneUrl", origin == null ? "" : origin);
            scmProperties.setProperty("origin", origin == null ? "" : OriginHelper.stripOrigin(gitProvenance.getOrigin()));
            scmProperties.setProperty("branch", gitProvenance.getBranch() == null ? "" : gitProvenance.getBranch());
            scmProperties.setProperty("change", gitProvenance.getChange() == null ? "" : gitProvenance.getChange());
            if (gitProvenance.getOrganizationName() == null || gitProvenance.getRepositoryName() == null) {
                scmProperties.setProperty("path", this.organization + "/" + this.repository);
            } else {
                scmProperties.setProperty("path", gitProvenance.getOrganizationName() + "/" + gitProvenance.getRepositoryName());
            }
            scmProperties.setProperty("created", this.mavenSession.getStartTime().toString());
        }
        scmProperties.setProperty("groupId", this.project.getGroupId());
        scmProperties.setProperty("artifactId", this.project.getArtifactId());
        scmProperties.setProperty("version", this.project.getVersion());
        ModerneJarLstMojo.addModernePluginProperties(scmProperties);
        return scmProperties;
    }

    public static void addModernePluginProperties(Properties scmProperties) {
        scmProperties.setProperty("buildPluginName", "moderne-maven-plugin");
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ModerneJarLstMojo.class.getResourceAsStream("/plugin-version.txt"))));){
                scmProperties.setProperty("buildPluginVersion", reader.readLine().trim());
            }
            reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ModerneJarLstMojo.class.getResourceAsStream("/ast-write-version.txt"))));
            try {
                scmProperties.setProperty("astWriteVersion", reader.readLine().trim());
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e2);
            }
        }
        return env.build();
    }

    ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t2 -> this.getLog().debug(t2));
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected Stream<SourceFile> listAsts() throws MojoExecutionException {
        MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);
        try {
            Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
            Path baseDir = this.getBaseDir();
            Environment env = this.environment();
            List styles = this.loadStyles(this.project, env);
            MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, (Collection)this.getExclusions(), (Collection)this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter, this.runPerSubmodule);
            ExecutionContext ctx = this.executionContext();
            Stream sourceFiles = projectParser.listSourceFiles(this.project, styles, ctx);
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            Stream stream = sourceFiles;
            meterRegistryProvider.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    meterRegistryProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DependencyResolutionRequiredException e2) {
                throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e2));
            }
        }
    }
}

