/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import io.moderne.maven.cli.ModerneCliProgressListener;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="moderneCli", threadSafe=true, instantiationStrategy=InstantiationStrategy.SINGLETON, defaultPhase=LifecyclePhase.PRE_CLEAN)
public class ModerneCliMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Parameter(property="moderne.cli.port", defaultValue="-1")
    private int port;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenExecutionRequest request;
        ExecutionListener originalListener;
        if (this.port > 0 && !((originalListener = (request = this.mavenSession.getRequest()).getExecutionListener()) instanceof ModerneCliProgressListener)) {
            ModerneCliProgressListener executionListener = new ModerneCliProgressListener(this.port, this.getLog(), originalListener);
            request.setExecutionListener((ExecutionListener)executionListener);
            List<String> projects = this.mavenSession.getAllProjects().stream().map(MavenProject::getName).collect(Collectors.toList());
            executionListener.projectList(projects);
        }
    }
}

