/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.plugin.logging.Log;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.tree.ParsingEventListener;

public class ModerneCliProgressListener
implements ExecutionListener,
ParsingEventListener {
    private final ExecutionListener chainedExecutionListener;
    private final ParsingEventListener chainedParsingListener;
    private final int port;
    private DatagramSocket socket;
    private InetAddress address;
    private final ObjectMapper mapper;
    private final Log log;

    public ModerneCliProgressListener(int cliPort, Log log, ParsingEventListener originalListener) {
        this(cliPort, log, null, originalListener);
    }

    public ModerneCliProgressListener(int cliPort, Log log, ExecutionListener originalListener) {
        this(cliPort, log, originalListener, null);
    }

    public ModerneCliProgressListener(int cliPort, Log log, ExecutionListener executionListener, ParsingEventListener parsingListener) {
        this.log = log;
        this.chainedExecutionListener = executionListener;
        this.chainedParsingListener = parsingListener;
        this.port = cliPort;
        try {
            this.socket = new DatagramSocket();
            this.address = InetAddress.getByName("localhost");
        }
        catch (SocketException | UnknownHostException e2) {
            System.err.println("It is not possible connect to localhost:" + this.port);
            e2.printStackTrace();
        }
        this.mapper = new ObjectMapper();
    }

    private boolean isEnabled() {
        return this.socket != null && this.address != null;
    }

    private void track(Object event) {
        if (this.isEnabled()) {
            try {
                String msg = this.mapper.writeValueAsString(event);
                this.log.debug((CharSequence)("Writting message:" + msg));
                byte[] buf = msg.getBytes();
                this.socket.send(new DatagramPacket(buf, buf.length, this.address, this.port));
            }
            catch (Exception e2) {
                this.log.warn((CharSequence)("It is not possible send message to localhost:" + this.port), (Throwable)e2);
            }
        }
    }

    private Map<String, Object> mapEvent(ExecutionEvent e2) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (e2.getProject() != null) {
            properties.put("project", e2.getProject().getName());
        }
        if (e2.getMojoExecution() != null) {
            properties.put("goal", e2.getMojoExecution().getGoal());
            properties.put("id", e2.getMojoExecution().getExecutionId());
            properties.put("phase", e2.getMojoExecution().getLifecyclePhase());
            properties.put("source", e2.getMojoExecution().getSource().name());
            properties.put("group", e2.getMojoExecution().getGroupId());
            properties.put("artifact", e2.getMojoExecution().getArtifactId());
            properties.put("version", e2.getMojoExecution().getVersion());
        }
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("tool", "maven");
        event.put("event-type", e2.getType().name());
        event.put("id", UUID.randomUUID());
        event.put("properties", properties);
        return event;
    }

    public void projectDiscoveryStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.projectDiscoveryStarted(executionEvent);
        }
    }

    public void sessionStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.sessionStarted(executionEvent);
        }
    }

    public void sessionEnded(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.sessionEnded(executionEvent);
        }
    }

    public void projectSkipped(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.projectSkipped(executionEvent);
        }
    }

    public void projectStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.projectStarted(executionEvent);
        }
    }

    public void projectSucceeded(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.projectSucceeded(executionEvent);
        }
    }

    public void projectFailed(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.projectFailed(executionEvent);
        }
    }

    public void mojoSkipped(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.mojoSkipped(executionEvent);
        }
    }

    public void mojoStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.mojoStarted(executionEvent);
        }
    }

    public void mojoSucceeded(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.mojoSucceeded(executionEvent);
        }
    }

    public void mojoFailed(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.mojoFailed(executionEvent);
        }
    }

    public void forkStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkStarted(executionEvent);
        }
    }

    public void forkSucceeded(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkSucceeded(executionEvent);
        }
    }

    public void forkFailed(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkFailed(executionEvent);
        }
    }

    public void forkedProjectStarted(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkedProjectStarted(executionEvent);
        }
    }

    public void forkedProjectSucceeded(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkedProjectSucceeded(executionEvent);
        }
    }

    public void forkedProjectFailed(ExecutionEvent executionEvent) {
        this.track(this.mapEvent(executionEvent));
        if (this.chainedExecutionListener != null) {
            this.chainedExecutionListener.forkedProjectFailed(executionEvent);
        }
    }

    public void projectList(List<String> projects) {
        HashMap<String, List<String>> properties = new HashMap<String, List<String>>();
        properties.put("projects", projects);
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("tool", "maven");
        event.put("event-type", "ProjectList");
        event.put("id", UUID.randomUUID());
        event.put("properties", properties);
        this.track(event);
    }

    public void parsed(Parser.Input input, SourceFile sourceFile) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("source", sourceFile.getSourcePath().toString());
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("tool", "maven");
        event.put("event-type", "ParserSource");
        event.put("id", UUID.randomUUID());
        event.put("properties", properties);
        this.track(event);
        if (this.chainedParsingListener != null) {
            this.chainedParsingListener.parsed(input, sourceFile);
        }
    }
}

