/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.serialization;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactoryBuilder;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.moderne.serialization.CompressionAlgorithm;
import io.moderne.serialization.JavaTypeVariants;
import io.moderne.serialization.LstFormatVersion;
import io.moderne.serialization.TreeSerializer$Builder;
import io.moderne.serialization.a;
import io.moderne.serialization.a.g;
import io.moderne.serialization.b.r;
import io.moderne.serialization.b.s;
import io.moderne.serialization.t;
import io.moderne.serialization.v;
import io.moderne.serialization.y;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.xml.style.Autodetect;

public class TreeSerializer {
    private final ObjectMapper a;
    private final MeterRegistry b;
    private final LstFormatVersion c;
    private final int d;
    private final g e;

    private TreeSerializer(MeterRegistry object, @Nullable ClassLoader classLoader, StreamReadConstraints streamReadConstraints, boolean bl, LstFormatVersion lstFormatVersion, long l2, int n2) {
        this.b = object;
        this.c = lstFormatVersion;
        this.d = n2;
        this.e = new g(bl, l2);
        object = this;
        streamReadConstraints = ((SmileFactoryBuilder)SmileFactory.builder().streamReadConstraints(streamReadConstraints)).enable(SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES).build();
        streamReadConstraints = JsonMapper.builder((JsonFactory)streamReadConstraints);
        object = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)streamReadConstraints.constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).disable(new MapperFeature[]{MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES})).build()).registerModule((Module)new v()).registerModule((Module)new ParameterNamesModule()).registerModule((Module)object.e).registerModule((Module)new io.moderne.serialization.a.a()).registerModule((Module)new y()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new t(0)).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        object.coercionConfigFor(LogicalType.Collection).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull).setAcceptBlankAsEmpty(Boolean.TRUE);
        if (classLoader != null) {
            object.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(classLoader));
        }
        Object object2 = object;
        this.a = object2.setVisibility(object2.getSerializationConfig().getDefaultVisibilityChecker().withCreatorVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE).withFieldVisibility(JsonAutoDetect.Visibility.ANY));
    }

    public long getNextUUID() {
        return this.e.a();
    }

    public List<SourceFile> read(InputStream inputStream) {
        List<SourceFile> list;
        block8: {
            Timer.Sample sample = Timer.start();
            String string = "unknown";
            inputStream = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(inputStream));
            try {
                string = inputStream.getClass().getSimpleName();
                List<SourceFile> list2 = (List<SourceFile>)this.a.readValue(inputStream, (TypeReference)new io.moderne.serialization.s(this));
                sample.stop(MetricsHelper.successTags((Timer.Builder)Timer.builder((String)"moderne.ast.load").tag("compressor", string)).register(this.b));
                sample = Timer.start();
                list2 = new r(this.c).a(list2);
                sample.stop(Timer.builder((String)"moderne.ast.postprocess").register(this.b));
                list = list2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    sample.stop(MetricsHelper.errorTags((Timer.Builder)Timer.builder((String)"moderne.ast.load").tag("compressor", string), (Throwable)throwable3).register(this.b));
                    throw throwable3;
                }
            }
            inputStream.close();
        }
        return list;
    }

    public List<File> write(Stream<SourceFile> stream, Path path, CompressionAlgorithm ... compressionAlgorithmArray) {
        return this.write(stream, path, () -> UUID.randomUUID() + ".lst", compressionAlgorithmArray);
    }

    public List<File> write(Stream<SourceFile> stream, Path path, Supplier<String> supplier, CompressionAlgorithm ... compressionAlgorithmArray) {
        if (!Files.exists(path, new LinkOption[0]) && !path.toFile().mkdirs()) {
            throw new UncheckedIOException(new IOException("Unable to write LSTs to " + path));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        Autodetect.Detector detector = Autodetect.detector();
        Autodetect.Detector detector2 = org.openrewrite.xml.style.Autodetect.detector();
        stream.peek(arg_0 -> ((Autodetect.Detector)detector).sample(arg_0)).peek(arg_0 -> ((Autodetect.Detector)detector2).sample(arg_0)).collect(new a(this.d, list2 -> {
            path = path.resolve((String)supplier.get()).toFile();
            try {
                this.write((List<SourceFile>)list2, null, (File)((Object)path), compressionAlgorithmArray);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            arrayList.add((File)((Object)path));
        }));
        this.writeStyles((NamedStyles)detector.build(), path);
        this.writeStyles((NamedStyles)detector2.build(), path);
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(List<SourceFile> list, @Nullable JavaTypeVariants object, File object2, CompressionAlgorithm ... object3) {
        object = new s((JavaTypeVariants)object, this.c);
        if (list.size() > 200) {
            throw new IllegalArgumentException("Use write(Stream, Path, ..) instead.");
        }
        object2 = Files.newOutputStream(((File)object2).toPath(), new OpenOption[0]);
        try {
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object2);){
                object3 = CompressionAlgorithm.compressor((CompressionAlgorithm[])object3, bufferedOutputStream);
                try {
                    list = ((s)object).a(list);
                    this.a.writeValue((OutputStream)object3, list);
                }
                finally {
                    if (object3 != null) {
                        ((OutputStream)object3).close();
                    }
                }
            }
            if (object2 == null) return;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((OutputStream)object2).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ((OutputStream)object2).close();
    }

    public void writeStyles(NamedStyles namedStyles, Path comparable) {
        comparable = comparable.resolve(namedStyles.getName() + ".styles").toFile();
        try {
            this.a.writeValue((File)comparable, (Object)namedStyles);
            return;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public NamedStyles readStyles(File file) {
        try {
            return (NamedStyles)this.a.readValue(file, NamedStyles.class);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static TreeSerializer$Builder builder() {
        return new TreeSerializer$Builder();
    }

    public ObjectMapper getMapper() {
        return this.a;
    }

    /* synthetic */ TreeSerializer(MeterRegistry meterRegistry, ClassLoader classLoader, StreamReadConstraints streamReadConstraints, boolean bl, LstFormatVersion lstFormatVersion, long l2, int n2, byte by) {
        this(meterRegistry, classLoader, streamReadConstraints, bl, lstFormatVersion, l2, n2);
    }
}

