/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.hibernate.search;

import io.moderne.hibernate.search.JPQLQueries;
import java.nio.file.Path;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Traits;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class FindJPQLDefinitions
extends Recipe {
    transient JPQLQueries queries = new JPQLQueries(this);
    private static final String NAMEDQUERY_FQN = "jakarta.persistence.NamedQuery";
    private static final String ENTITYMANAGER_FQN = "jakarta.persistence.EntityManager";

    public String getDisplayName() {
        return "Find JPQL definitions";
    }

    public String getDescription() {
        return "Find Java Persistence Query Language definitions in the codebase.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(NAMEDQUERY_FQN, Boolean.valueOf(false)), new UsesType(ENTITYMANAGER_FQN, Boolean.valueOf(false))}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t = super.visit(tree, (Object)ctx);
                if (!(tree instanceof SourceFile)) {
                    return t;
                }
                Path sourcePath = ((SourceFile)tree).getSourcePath();
                t = Traits.annotated((String)"@jakarta.persistence.NamedQuery").asVisitor(a -> ((J.Annotation)a.getTree()).withArguments(ListUtils.map((List)((J.Annotation)a.getTree()).getArguments(), arg -> this.inspectQueryArguments((Expression)arg, sourcePath, ctx)))).visit(t, (Object)ctx);
                t = Traits.methodAccess((String)"jakarta.persistence.EntityManager createQuery(String,..)").asVisitor(ma -> ((MethodCall)ma.getTree()).withArguments(ListUtils.mapFirst((List)((MethodCall)ma.getTree()).getArguments(), arg -> this.inspectExpression((Expression)arg, sourcePath, ctx)))).visit(t, (Object)ctx);
                return t;
            }

            private Expression inspectExpression(Expression arg, Path sourcePath, ExecutionContext ctx) {
                if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String) {
                    String value = (String)((J.Literal)arg).getValue();
                    FindJPQLDefinitions.this.queries.insertRow(ctx, new JPQLQueries.Row(sourcePath.toString(), value));
                    return (Expression)SearchResult.found((Tree)arg);
                }
                return arg;
            }

            private Expression inspectQueryArguments(Expression arg, Path sourcePath, ExecutionContext ctx) {
                J.Assignment assignment;
                if (arg instanceof J.Assignment && "query".equals(((J.Identifier)(assignment = (J.Assignment)arg).getVariable()).getSimpleName())) {
                    Expression maybeFound = this.inspectExpression(assignment.getAssignment(), sourcePath, ctx);
                    return assignment.withAssignment(maybeFound);
                }
                return arg;
            }
        });
    }
}

