/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.hibernate.update66;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;

public final class FixConflictingClassTypeAnnotations
extends Recipe {
    private static final String ENTITY_FQN = "jakarta.persistence.Entity";
    private static final String MAPPEDSUPERCLASS_FQN = "jakarta.persistence.MappedSuperclass";
    private static final String EMBEDDABLE_FQN = "jakarta.persistence.Embeddable";
    private static final AnnotationMatcher entityMatcher = new AnnotationMatcher("jakarta.persistence.Entity");
    private static final AnnotationMatcher mappedsuperclassMatcher = new AnnotationMatcher("jakarta.persistence.MappedSuperclass");
    private static final AnnotationMatcher embeddableMatcher = new AnnotationMatcher("jakarta.persistence.Embeddable");

    public String getDisplayName() {
        return "Fix conflicting class type annotation Hibernate 6.6";
    }

    public String getDescription() {
        return "Since Hibernate 6.6 a mapped class can have *either* `@MappedSuperclass` or `@Embeddable`, or `@Entity`. This recipe removes `@Entity` from classes annotated with `@MappedSuperclass` or `@Embeddable`.For the moment die combination of `@MappedSuperclass` or `@Embeddable` is advised to migrate to [Single Table Inheritance](https://docs.jboss.org/hibernate/orm/6.6/userguide/html_single/Hibernate_User_Guide.html#entity-inheritance-single-table)but still accepted and therefore stays.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType(ENTITY_FQN, Boolean.valueOf(false)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(MAPPEDSUPERCLASS_FQN, Boolean.valueOf(false)), new UsesType(EMBEDDABLE_FQN, Boolean.valueOf(false))})}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (FixConflictingClassTypeAnnotations.isConflicting(((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor()))) {
                    this.maybeRemoveImport(FixConflictingClassTypeAnnotations.ENTITY_FQN);
                    return (J.ClassDeclaration)new RemoveAnnotationVisitor(entityMatcher).visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                }
                return cd;
            }
        });
    }

    private static boolean isConflicting(List<J.Annotation> annotations) {
        boolean entityPresent = false;
        boolean conflictPossible = false;
        for (J.Annotation annotation : annotations) {
            if (embeddableMatcher.matches(annotation) || mappedsuperclassMatcher.matches(annotation)) {
                conflictPossible = true;
            } else if (entityMatcher.matches(annotation)) {
                entityPresent = true;
            }
            if (!entityPresent || !conflictPossible) continue;
            return true;
        }
        return false;
    }

    @Generated
    public FixConflictingClassTypeAnnotations() {
    }

    @Generated
    public String toString() {
        return "FixConflictingClassTypeAnnotations()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixConflictingClassTypeAnnotations)) {
            return false;
        }
        FixConflictingClassTypeAnnotations other = (FixConflictingClassTypeAnnotations)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FixConflictingClassTypeAnnotations;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

