/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.hibernate.update66;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveTableFromInheritedEntity
extends ScanningRecipe<Set<JavaType.FullyQualified>> {
    private static final String ENTITY_FQN = "jakarta.persistence.Entity";
    private static final String TABLE_FQN = "jakarta.persistence.Table";
    private static final String INHERITANCE_FQN = "jakarta.persistence.Inheritance";
    private static final AnnotationMatcher entityMatcher = new AnnotationMatcher("jakarta.persistence.Entity");
    private static final AnnotationMatcher tableMatcher = new AnnotationMatcher("jakarta.persistence.Table");
    private static final AnnotationMatcher inheritanceMatcher = new AnnotationMatcher("jakarta.persistence.Inheritance");

    public String getDisplayName() {
        return "Remove table from single table inherited entity";
    }

    public String getDescription() {
        return "For Single Table Inherited Entities Hibernate ignores the `@Table` annotation on child entities. From Version 6.6 it is considered an error.";
    }

    public Set<JavaType.FullyQualified> getInitialValue(ExecutionContext ctx) {
        return new HashSet<JavaType.FullyQualified>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Set<JavaType.FullyQualified> acc) {
        return Preconditions.check((TreeVisitor)new UsesType(ENTITY_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                JavaType.FullyQualified fq = TypeUtils.asFullyQualified((JavaType)cd.getType());
                if (fq != null && this.shouldRemoveTableAnnotation()) {
                    acc.add(fq);
                }
                return cd;
            }

            private boolean shouldRemoveTableAnnotation() {
                boolean isEntity = false;
                boolean isSingleTable = true;
                for (J.Annotation anno : ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor())) {
                    if (entityMatcher.matches(anno)) {
                        isEntity = true;
                    }
                    if (!inheritanceMatcher.matches(anno) || this.hasStrategySingleTable(anno.getArguments())) continue;
                    isSingleTable = false;
                }
                return isEntity && isSingleTable;
            }

            private boolean hasStrategySingleTable(@Nullable List<Expression> arguments) {
                if (arguments != null) {
                    for (Expression argument : arguments) {
                        if (!(argument instanceof J.Assignment)) continue;
                        J.Assignment assignment = (J.Assignment)argument;
                        return "strategy".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && "SINGLE_TABLE".equals(this.getValue(assignment.getAssignment()));
                    }
                }
                return true;
            }

            private @Nullable String getValue(Expression assignment) {
                if (assignment instanceof J.Identifier) {
                    return ((J.Identifier)assignment).getSimpleName();
                }
                if (assignment instanceof J.FieldAccess) {
                    return ((J.FieldAccess)assignment).getSimpleName();
                }
                return null;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Set<JavaType.FullyQualified> acc) {
        return Preconditions.check((TreeVisitor)new UsesType(TABLE_FQN, Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() != null && acc.contains(TypeUtils.asFullyQualified((JavaType)cd.getExtends().getType()))) {
                    this.maybeRemoveImport(RemoveTableFromInheritedEntity.TABLE_FQN);
                    return (J.ClassDeclaration)new RemoveAnnotationVisitor(tableMatcher).visitNonNull((Tree)cd, (Object)ctx, this.getCursor().getParentTreeCursor());
                }
                return cd;
            }
        });
    }
}

