/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class RemoveTestRestTemplateEnableRedirectsOptionRecipe
extends Recipe {
    public static final String REST_TEMPLATE_$_HTTP_CLIENT_OPTION = "org.springframework.boot.test.web.client.TestRestTemplate$HttpClientOption";

    public String getDisplayName() {
        return "Remove `TestRestTemplate.HttpClientOption.ENABLE_REDIRECTS` option";
    }

    public String getDescription() {
        return "The `TestRestTemplate` now uses the same follow redirects settings as the regular RestTemplate. The `HttpOption.ENABLE_REDIRECTS` option has also been deprecated. This recipe removes the option from the `TestRestTemplate` constructor arguments.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
                List arguments = nc.getArguments();
                if (!arguments.isEmpty()) {
                    Space firstArgumentPrefix = ((Expression)arguments.get(0)).getPrefix();
                    arguments = ListUtils.filter((List)arguments, a -> !this.isTestRestTemplateHttpClientOptionENABLEREDIRECTS((Expression)a));
                    arguments = ListUtils.mapFirst((List)arguments, a -> (Expression)a.withPrefix(firstArgumentPrefix));
                }
                return nc.withArguments(arguments);
            }

            private boolean isTestRestTemplateHttpClientOptionENABLEREDIRECTS(Expression e) {
                return e instanceof J.FieldAccess && TypeUtils.isOfClassType((JavaType)e.getType(), (String)RemoveTestRestTemplateEnableRedirectsOptionRecipe.REST_TEMPLATE_$_HTTP_CLIENT_OPTION) && ((J.FieldAccess)e).getSimpleName().equals("ENABLE_REDIRECTS");
            }
        };
    }
}

