/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceKafkaTransactionManagerSetter
extends Recipe {
    private static final String SET_TRANSACTION_MANAGER = "org.springframework.kafka.listener.ContainerProperties setTransactionManager(org.springframework.transaction.PlatformTransactionManager)";
    private static final MethodMatcher PLATFORM_TRANSACTION_MANAGER_MATCHER = new MethodMatcher("org.springframework.kafka.listener.ContainerProperties setTransactionManager(org.springframework.transaction.PlatformTransactionManager)");
    private static final String KAFKA_AWARE_TRANSACTION_MANAGER = "org.springframework.kafka.transaction.KafkaAwareTransactionManager";
    private static final TypeMatcher KAFKA_AWARE_TRANSACTION_MANAGER_MATCHER = new TypeMatcher("org.springframework.kafka.transaction.KafkaAwareTransactionManager", true);
    private static final String NEW_METHOD_NAME = "setKafkaAwareTransactionManager";

    public String getDisplayName() {
        return "Use `kafkaAwareTransactionManager` setter";
    }

    public String getDescription() {
        return "Replace deprecated `ContainerProperties#setTransactionManager(org.springframework.transaction.PlatformTransactionManager)` method with `ContainerProperties#setKafkaAwareTransactionManager(org.springframework.kafka.transaction.KafkaAwareTransactionManager)`. The method will be replaced only if its argument has the type `KafkaAwareTransactionManager`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(PLATFORM_TRANSACTION_MANAGER_MATCHER), new UsesType(KAFKA_AWARE_TRANSACTION_MANAGER, Boolean.valueOf(true))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (PLATFORM_TRANSACTION_MANAGER_MATCHER.matches((MethodCall)mi)) {
                    JavaType argumentType = ((Expression)mi.getArguments().get(0)).getType();
                    if (KAFKA_AWARE_TRANSACTION_MANAGER_MATCHER.matches(argumentType)) {
                        mi = mi.withMethodType(mi.getMethodType().withName(ReplaceKafkaTransactionManagerSetter.NEW_METHOD_NAME).withParameterTypes(Collections.singletonList(argumentType))).withName(mi.getName().withSimpleName(ReplaceKafkaTransactionManagerSetter.NEW_METHOD_NAME));
                    }
                }
                return mi;
            }
        });
    }
}

