/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ResolveTaskExecutorFromContext
extends Recipe {
    private static final MethodMatcher METHOD_MATCHER = new MethodMatcher("org.springframework.beans.factory.* getBean(..)");

    public String getDisplayName() {
        return "Replace `taskExecutor` with `applicationTaskExecutor`";
    }

    public String getDescription() {
        return "Use bean name `applicationTaskExecutor` instead of `taskExecutor` when resolving `TaskExecutor` Bean from application context";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(METHOD_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                if ("taskExecutor".equals(literal.getValue()) && METHOD_MATCHER.matches((MethodCall)this.getCursor().firstEnclosing(J.MethodInvocation.class))) {
                    return literal.withValue((Object)"applicationTaskExecutor").withValueSource("\"applicationTaskExecutor\"");
                }
                return super.visitLiteral(literal, (Object)ctx);
            }
        });
    }
}

