/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.dynamodb.repository;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockPersistenceException;
import io.mongock.driver.core.lock.LockRepository;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.driver.dynamodb.repository.DynamoDBLockRepositoryKt;
import io.mongock.driver.dynamodb.repository.DynamoDbRepositoryBase;
import io.mongock.driver.dynamodb.repository.LockEntryDynamoDB;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J,\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016\u00a8\u0006\u001a"}, d2={"Lio/mongock/driver/dynamodb/repository/DynamoDBLockRepository;", "Lio/mongock/driver/core/lock/LockRepository;", "Lio/mongock/driver/dynamodb/repository/DynamoDbRepositoryBase;", "client", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;", "tableName", "", "indexCreation", "", "provisionedThroughput", "Lcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;", "(Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClient;Ljava/lang/String;ZLcom/amazonaws/services/dynamodbv2/model/ProvisionedThroughput;)V", "findByKey", "Lio/mongock/driver/core/lock/LockEntry;", "lockKey", "insertUpdate", "", "newLock", "performUpdate", "expression", "expressionAttributeValues", "", "Lcom/amazonaws/services/dynamodbv2/model/AttributeValue;", "removeByKeyAndOwner", "owner", "updateIfSameOwner", "dynamodb-driver"})
public final class DynamoDBLockRepository
extends DynamoDbRepositoryBase
implements LockRepository {
    public DynamoDBLockRepository(@NotNull AmazonDynamoDBClient client, @NotNull String tableName, boolean indexCreation, @Nullable ProvisionedThroughput provisionedThroughput) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        super(client, tableName, Reflection.getOrCreateKotlinClass(LockEntryDynamoDB.class), indexCreation, provisionedThroughput);
    }

    public void insertUpdate(@NotNull LockEntry newLock) throws LockPersistenceException {
        Intrinsics.checkNotNullParameter((Object)newLock, (String)"newLock");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)":owner_value", (Object)new AttributeValue().withS(newLock.getOwner())), TuplesKt.to((Object)":now_value", (Object)new AttributeValue().withN(String.valueOf(new Date().getTime())))};
        Map expressionAttributeValues = MapsKt.mapOf((Pair[])pairArray);
        String expression = "attribute_not_exists(lock_key) OR expiresAt < :now_value OR lock_owner = :owner_value";
        this.performUpdate(newLock, expression, expressionAttributeValues);
    }

    public void updateIfSameOwner(@NotNull LockEntry newLock) throws LockPersistenceException {
        Intrinsics.checkNotNullParameter((Object)newLock, (String)"newLock");
        String expression = "attribute_exists(lock_key) AND lock_owner = :owner_value AND lock_status = :status_value";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)":owner_value", (Object)new AttributeValue().withS(newLock.getOwner())), TuplesKt.to((Object)":status_value", (Object)new AttributeValue().withS(LockStatus.LOCK_HELD.name()))};
        Map expressionAttributeValues = MapsKt.mapOf((Pair[])pairArray);
        this.performUpdate(newLock, expression, expressionAttributeValues);
    }

    @Nullable
    public LockEntry findByKey(@NotNull String lockKey) {
        LockEntry lockEntry;
        Intrinsics.checkNotNullParameter((Object)lockKey, (String)"lockKey");
        GetItemRequest request = new GetItemRequest().withTableName(this.getTableName()).withConsistentRead(Boolean.valueOf(true)).withKey(MapsKt.mapOf((Pair)TuplesKt.to((Object)"lock_key", (Object)new AttributeValue().withS(lockKey))));
        GetItemResult result = this.getClient().getItem(request);
        if (result.getItem() != null) {
            Map map = result.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.item");
            lockEntry = new LockEntryDynamoDB(map).getLockEntry$dynamodb_driver();
        } else {
            lockEntry = null;
        }
        return lockEntry;
    }

    public void removeByKeyAndOwner(@NotNull String lockKey, @NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)lockKey, (String)"lockKey");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        DeleteItemRequest request = new DeleteItemRequest().withTableName(this.getTableName()).withKey(MapsKt.mapOf((Pair)TuplesKt.to((Object)"lock_key", (Object)new AttributeValue().withS(lockKey)))).withConditionExpression("attribute_exists(lock_key) AND lock_owner = :owner_value").withExpressionAttributeValues(MapsKt.mapOf((Pair)TuplesKt.to((Object)":owner_value", (Object)new AttributeValue().withS(owner))));
        try {
            DynamoDBLockRepositoryKt.access$getLogger$p().debug((Function0)new Function0<Object>(request){
                final /* synthetic */ DeleteItemRequest $request;
                {
                    this.$request = $request;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"...trying  to delete lock request: ", (Object)this.$request);
                }
            });
            DeleteItemResult result = this.getClient().deleteItem(request);
            DynamoDBLockRepositoryKt.access$getLogger$p().debug((Function0)new Function0<Object>(result){
                final /* synthetic */ DeleteItemResult $result;
                {
                    this.$result = $result;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"deletion successfully performed: ", (Object)this.$result);
                }
            });
        }
        catch (ConditionalCheckFailedException ex) {
            DynamoDBLockRepositoryKt.access$getLogger$p().warn((Function0)new Function0<Object>(ex){
                final /* synthetic */ ConditionalCheckFailedException $ex;
                {
                    this.$ex = $ex;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$ex.getMessage();
                }
            });
        }
        catch (Throwable ex) {
            throw new MongockException(ex);
        }
    }

    private final void performUpdate(LockEntry newLock, String expression, Map<String, ? extends AttributeValue> expressionAttributeValues) {
        LockEntryDynamoDB lockDynamoDB = new LockEntryDynamoDB(newLock);
        PutItemRequest request = new PutItemRequest().withTableName(this.getTableName()).withItem(lockDynamoDB.getAttributes$dynamodb_driver()).withConditionExpression(expression).withExpressionAttributeValues(expressionAttributeValues);
        try {
            DynamoDBLockRepositoryKt.access$getLogger$p().debug((Function0)new Function0<Object>(request){
                final /* synthetic */ PutItemRequest $request;
                {
                    this.$request = $request;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"...trying  lock request: ", (Object)this.$request);
                }
            });
            PutItemResult result = this.getClient().putItem(request);
            DynamoDBLockRepositoryKt.access$getLogger$p().debug((Function0)new Function0<Object>(result){
                final /* synthetic */ PutItemResult $result;
                {
                    this.$result = $result;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return Intrinsics.stringPlus((String)"insertUpdate successfully performed: ", (Object)this.$result);
                }
            });
        }
        catch (ConditionalCheckFailedException ex) {
            throw new LockPersistenceException(request.toString(), lockDynamoDB.toString(), ex.getMessage());
        }
        catch (Throwable ex) {
            throw new MongockException(ex);
        }
    }
}

