/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.jwt.parser;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.mongock.jwt.api.JwtExpiredException;
import io.mongock.jwt.api.JwtMongock;
import io.mongock.jwt.api.LicenseType;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/mongock/jwt/parser/JwtParser;", "", "rsaPublicKey", "", "(Ljava/lang/String;)V", "publicKey", "Ljava/security/PublicKey;", "parse", "Lio/mongock/jwt/api/JwtMongock;", "jwtToken", "jwt-parser"})
public final class JwtParser {
    @NotNull
    private final PublicKey publicKey;

    public JwtParser(@NotNull String rsaPublicKey) {
        X509EncodedKeySpec it;
        Intrinsics.checkNotNullParameter((Object)rsaPublicKey, (String)"rsaPublicKey");
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)rsaPublicKey, (String)"-----BEGIN PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null), (String)"-----END PUBLIC KEY-----", (String)"", (boolean)false, (int)4, null);
        JwtParser jwtParser = this;
        boolean bl = false;
        it = new X509EncodedKeySpec(Base64.getDecoder().decode((String)((Object)it)));
        boolean bl2 = false;
        PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(it);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"rsaPublicKey\n        .re\u2026SA\").generatePublic(it) }");
        jwtParser.publicKey = publicKey;
    }

    @NotNull
    public final JwtMongock parse(@NotNull String jwtToken) {
        JwtMongock jwtMongock;
        Intrinsics.checkNotNullParameter((Object)jwtToken, (String)"jwtToken");
        try {
            Jws it = Jwts.parserBuilder().setSigningKey((Key)this.publicKey).build().parseClaimsJws(jwtToken);
            boolean bl = false;
            Object object = it.getSignature();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.signature");
            String string = object;
            object = ((JwsHeader)it.getHeader()).getAlgorithm();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.header.algorithm");
            String string2 = object;
            object = ((Claims)it.getBody()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.id");
            String string3 = object;
            object = ((Claims)it.getBody()).getAudience();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.audience");
            String string4 = object;
            object = ((Claims)it.getBody()).getIssuer();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.issuer");
            String string5 = object;
            object = ((Claims)it.getBody()).getSubject();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.subject");
            String string6 = object;
            object = ((Claims)it.getBody()).getIssuedAt().toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.issuedAt.toInsta\u2026et.UTC).toLocalDateTime()");
            Object object2 = object;
            object = ((Claims)it.getBody()).getExpiration().toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body.expiration.toIns\u2026et.UTC).toLocalDateTime()");
            Object object3 = object;
            object = ((Claims)it.getBody()).get("licenseId", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body[LICENSE_ID_FIELD, String::class.java]");
            String string7 = (String)object;
            object = ((Claims)it.getBody()).get("licenseType", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body[LICENSE_TYPE_FIELD, String::class.java]");
            LicenseType licenseType = LicenseType.valueOf((String)((String)object));
            object = ((Claims)it.getBody()).get("email", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body[EMAIL_FIELD, String::class.java]");
            String string8 = (String)object;
            object = ((Claims)it.getBody()).get("companyName", String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.body[COMPANY_NAME_FIELD, String::class.java]");
            Object object4 = ((Claims)it.getBody()).get((Object)"schemas");
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
            }
            jwtMongock = new JwtMongock(string, string2, string3, string4, string5, string6, (LocalDateTime)object2, (LocalDateTime)object3, string7, licenseType, string8, (String)object, ((Integer)object4).intValue());
        }
        catch (ExpiredJwtException ex) {
            throw new JwtExpiredException(ex);
        }
        return jwtMongock;
    }
}

