/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.core.driver;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.driver.core.lock.DefaultLockManager;
import io.mongock.driver.core.lock.LockRepository;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Set;

@NotThreadSafe
public abstract class ConnectionDriverBase
implements ConnectionDriver {
    private static final String DEFAULT_MIGRATION_REPOSITORY_NAME = "mongockChangeLog";
    private static final String DEFAULT_LOCK_REPOSITORY_NAME = "mongockLock";
    private static final TimeService TIME_SERVICE = new TimeService();
    protected final long lockAcquiredForMillis;
    protected final long lockQuitTryingAfterMillis;
    protected final long lockTryFrequencyMillis;
    protected boolean initialized = false;
    protected LockManager lockManager = null;
    protected String migrationRepositoryName;
    protected String lockRepositoryName;
    protected boolean indexCreation = true;

    protected ConnectionDriverBase(long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        this.lockAcquiredForMillis = lockAcquiredForMillis;
        this.lockQuitTryingAfterMillis = lockQuitTryingAfterMillis;
        this.lockTryFrequencyMillis = lockTryFrequencyMillis;
    }

    public final void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            LockRepository lockRepository = this.getLockRepository();
            lockRepository.initialize();
            this.lockManager = DefaultLockManager.builder().setLockRepository(lockRepository).setLockAcquiredForMillis(this.lockAcquiredForMillis).setLockQuitTryingAfterMillis(this.lockQuitTryingAfterMillis).setLockTryFrequencyMillis(this.lockTryFrequencyMillis).build();
            ChangeEntryService changeEntryService = this.getChangeEntryService();
            changeEntryService.initialize();
            this.specificInitialization();
        }
    }

    public LockManager getLockManager() {
        if (this.lockManager == null) {
            throw new MongockException("Internal error: Driver needs to be initialized by the runner");
        }
        return this.lockManager;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final void setMigrationRepositoryName(String migrationRepositoryName) {
        if (migrationRepositoryName != null || this.migrationRepositoryName == null) {
            this.migrationRepositoryName = migrationRepositoryName;
        }
    }

    public final void setLockRepositoryName(String lockRepositoryName) {
        if (lockRepositoryName != null || this.lockRepositoryName == null) {
            this.lockRepositoryName = lockRepositoryName;
        }
    }

    public final String getMigrationRepositoryName() {
        return this.migrationRepositoryName != null ? this.migrationRepositoryName : DEFAULT_MIGRATION_REPOSITORY_NAME;
    }

    public final String getLockRepositoryName() {
        return this.lockRepositoryName != null ? this.lockRepositoryName : DEFAULT_LOCK_REPOSITORY_NAME;
    }

    public boolean isIndexCreation() {
        return this.indexCreation;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }

    protected abstract LockRepository getLockRepository();

    protected void specificInitialization() {
    }

    public void runValidation() throws MongockException {
    }

    @Deprecated
    public void setChangeLogRepositoryName(String migrationRepositoryName) {
        this.setMigrationRepositoryName(migrationRepositoryName);
    }

    protected void removeDependencyIfAssignableFrom(Set<ChangeSetDependency> dependencies, Class<?> type) {
        if (dependencies != null) {
            dependencies.removeIf(d -> type.isAssignableFrom(d.getType()));
        }
    }
}

