/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor.dependency;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.ForbiddenParameterException;
import io.mongock.driver.api.common.Validable;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.ChangeSetDependencyBuildable;
import io.mongock.driver.api.lock.guard.proxy.LockGuardProxyFactory;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@NotThreadSafe
public class DependencyManager
implements Validable {
    private final LinkedHashSet<ChangeSetDependency> connectorDependencies;
    private final LinkedHashSet<ChangeSetDependency> standardDependencies = new LinkedHashSet();
    protected LockGuardProxyFactory lockGuardProxyFactory;

    public DependencyManager() {
        this.connectorDependencies = new LinkedHashSet();
    }

    public Optional<Object> getDependency(Class type, boolean lockGuarded) throws ForbiddenParameterException {
        return this.getDependency(type, null, lockGuarded);
    }

    public Optional<Object> getDependency(Class type, String name, boolean lockGuarded) throws ForbiddenParameterException {
        Optional<ChangeSetDependency> dependencyOpt = this.getDependencyFromStore(this.connectorDependencies, type, name);
        if (!dependencyOpt.isPresent()) {
            dependencyOpt = this.getDependencyFromStore(this.standardDependencies, type, name);
        }
        if (!dependencyOpt.isPresent()) {
            return Optional.empty();
        }
        ChangeSetDependency dependency = dependencyOpt.get();
        if (ChangeSetDependencyBuildable.class.isAssignableFrom(dependency.getClass())) {
            ChangeSetDependencyBuildable buildable = (ChangeSetDependencyBuildable)dependency;
            Optional<Object> implOpt = this.getDependency(buildable.getImplType(), buildable.isProxeable());
            if (!implOpt.isPresent()) {
                return Optional.empty();
            }
            return implOpt.map(buildable.getDecoratorFunction());
        }
        return dependency.isProxeable() && lockGuarded ? Optional.of(this.lockGuardProxyFactory.getRawProxy(dependency.getInstance(), type)) : Optional.ofNullable(dependency.getInstance());
    }

    private Optional<ChangeSetDependency> getDependencyFromStore(Collection<ChangeSetDependency> dependencyStore, Class<?> type, String name) {
        boolean byName = name != null && !name.isEmpty() && !"default_name_not_used".equals(name);
        Predicate<ChangeSetDependency> filter = byName ? dependency -> name.equals(dependency.getName()) : dependency -> type.isAssignableFrom(dependency.getType());
        Stream<ChangeSetDependency> stream = dependencyStore.stream().filter(filter);
        if (byName) {
            return stream.findFirst();
        }
        return stream.reduce((dependency1, dependency2) -> !dependency1.isDefaultNamed() && dependency2.isDefaultNamed() ? dependency2 : dependency1);
    }

    public DependencyManager setLockGuardProxyFactory(LockGuardProxyFactory lockGuardProxyFactory) {
        this.lockGuardProxyFactory = lockGuardProxyFactory;
        return this;
    }

    public DependencyManager addDriverDependencies(Collection<? extends ChangeSetDependency> dependencies) {
        dependencies.forEach(this::addDriverDependency);
        return this;
    }

    public DependencyManager addDriverDependency(ChangeSetDependency dependency) {
        return this.addDependency(this.connectorDependencies, dependency);
    }

    public DependencyManager addStandardDependencies(Collection<? extends ChangeSetDependency> dependencies) {
        dependencies.forEach(this::addStandardDependency);
        return this;
    }

    public DependencyManager addStandardDependency(ChangeSetDependency dependency) {
        return this.addDependency(this.standardDependencies, dependency);
    }

    private <T extends ChangeSetDependency> DependencyManager addDependency(Collection<T> dependencyStore, T dependency) {
        if (!dependencyStore.add(dependency)) {
            dependencyStore.remove(dependency);
            dependencyStore.add(dependency);
        }
        return this;
    }

    public void runValidation() throws MongockException {
    }
}

