/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.builder.roles;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.runner.core.builder.roles.Configurable;
import io.mongock.runner.core.builder.roles.SelfInstanstiator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public interface ChangeLogScanner<SELF extends ChangeLogScanner<SELF, CONFIG>, CONFIG extends MongockConfiguration>
extends Configurable<SELF, CONFIG>,
SelfInstanstiator<SELF> {
    default public SELF setDefaultAuthor(String defaultMigrationAuthor) {
        this.getConfig().setDefaultAuthor(defaultMigrationAuthor);
        return (SELF)((ChangeLogScanner)this.getInstance());
    }

    default public SELF addMigrationScanPackages(List<String> migrationScanPackageList) {
        if (migrationScanPackageList != null) {
            this.getConfig().getMigrationScanPackage().addAll(migrationScanPackageList);
        }
        return (SELF)((ChangeLogScanner)this.getInstance());
    }

    default public SELF addMigrationScanPackage(String migrationScanPackage) {
        return this.addMigrationScanPackages(Collections.singletonList(migrationScanPackage));
    }

    default public SELF addMigrationClasses(List<Class<?>> classes) {
        if (classes != null) {
            classes.stream().map(Class::getName).forEach(this.getConfig().getMigrationScanPackage()::add);
        }
        return (SELF)((ChangeLogScanner)this.getInstance());
    }

    default public SELF addMigrationClass(Class<?> clazz) {
        return this.addMigrationClasses(Collections.singletonList(clazz));
    }

    @Deprecated
    public SELF setChangeLogInstantiator(Function<Class<?>, Object> var1);

    @Deprecated
    default public SELF addChangeLogsScanPackages(List<String> migrationScanPackageList) {
        return this.addMigrationScanPackages(migrationScanPackageList);
    }

    @Deprecated
    default public SELF addChangeLogsScanPackage(String migrationScanPackage) {
        return this.addMigrationScanPackage(migrationScanPackage);
    }

    @Deprecated
    default public SELF addChangeLogClasses(List<Class<?>> classes) {
        return this.addMigrationClasses(classes);
    }

    @Deprecated
    default public SELF addChangeLogClass(Class<?> clazz) {
        return this.addMigrationClass(clazz);
    }
}

