/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor;

import com.google.gson.Gson;
import io.mongock.api.config.TransactionStrategy;
import io.mongock.api.config.executor.ChangeExecutorConfiguration;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.SystemChange;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeEntryExecuted;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import io.mongock.runner.core.executor.Executor;
import io.mongock.runner.core.executor.NonTransactioner;
import io.mongock.runner.core.executor.changelog.ChangeLogRuntime;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.internal.ChangeLogItem;
import io.mongock.runner.core.internal.ChangeSetItem;
import io.mongock.utils.StringUtils;
import io.mongock.utils.Triple;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class ChangeExecutorBase<CONFIG extends ChangeExecutorConfiguration>
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(ChangeExecutorBase.class);
    protected final Boolean globalTransactionEnabled;
    protected final Deque<Triple<Object, ChangeSetItem, Exception>> changeSetsToRollBack = new ArrayDeque<Triple<Object, ChangeSetItem, Exception>>();
    protected final ChangeLogServiceBase changeLogService;
    protected final ConnectionDriver driver;
    protected final String serviceIdentifier;
    protected final boolean trackIgnored;
    protected final Map<String, Object> metadata;
    protected final ChangeLogRuntime changeLogRuntime;
    protected final Function<AnnotatedElement, Boolean> annotationFilter;
    protected boolean executionInProgress = false;
    protected final String executionId;
    private final TransactionStrategy transactionStrategy;
    protected final CONFIG config;
    protected List<ChangeEntryExecuted> executedChangeEntries = null;

    public ChangeExecutorBase(String executionId, ChangeLogServiceBase changeLogService, ConnectionDriver driver, ChangeLogRuntime changeLogRuntime, Function<AnnotatedElement, Boolean> annotationFilter, Map<String, Object> metadata, String serviceIdentifier, boolean trackIgnored, Optional<Boolean> transactionEnabled, TransactionStrategy transactionStrategy, CONFIG config) {
        this.executionId = executionId;
        this.changeLogService = changeLogService;
        this.driver = driver;
        this.changeLogRuntime = changeLogRuntime;
        this.annotationFilter = annotationFilter;
        this.metadata = metadata;
        this.serviceIdentifier = serviceIdentifier;
        this.trackIgnored = trackIgnored;
        this.globalTransactionEnabled = transactionEnabled.orElse(null);
        this.transactionStrategy = transactionStrategy;
        this.config = config;
    }

    @Override
    public boolean isExecutionInProgress() {
        return this.executionInProgress;
    }

    protected void processMigration(Collection<ChangeLogItem> changeLogs, String executionId, String executionHostname) {
        this.prepareForStageExecutionIfApply(this.isStrategyPerMigration());
        this.driver.getTransactioner().filter(t -> this.isStrategyPerMigration() && this.isDriverTransactional()).orElse(new NonTransactioner()).executeInTransaction(() -> this.processChangeLogs(executionId, executionHostname, changeLogs));
    }

    protected void processChangeLogs(String executionId, String executionHostname, Collection<ChangeLogItem> changeLogs) {
        for (ChangeLogItem changeLog : changeLogs) {
            this.validateChangeLog(changeLog);
            this.processSingleChangeLog(executionId, executionHostname, changeLog);
        }
    }

    protected abstract void validateChangeLog(ChangeLogItem var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSingleChangeLog(String executionId, String executionHostname, ChangeLogItem changeLog) {
        try {
            this.prepareForStageExecutionIfApply(this.isStrategyPerChangeUnit() && changeLog.isTransactional());
            Object changeLogInstance = this.getChangeLogInstance(changeLog.getType());
            this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLog, changeLog.getBeforeItems());
            this.processChangeLogInTransactionIfApplies(executionId, executionHostname, changeLogInstance, changeLog);
            if (changeLog.isSystem() && changeLog.getType().isAnnotationPresent(SystemChange.class) && changeLog.getType().getAnnotation(SystemChange.class).updatesSystemTable()) {
                this.loadExecutedChangeEntries();
            }
        }
        catch (Exception e) {
            if (changeLog.isFailFast()) {
                this.rollbackProcessedChangeSetsIfApply(executionId, executionHostname, this.changeSetsToRollBack);
                throw e;
            }
        }
        finally {
            this.clearChangeSetsToRollbackIfApply(this.isStrategyPerChangeUnit());
        }
    }

    protected Object getChangeLogInstance(Class<?> changeLogClass) {
        this.injectDependenciesFromDriver();
        return this.changeLogRuntime.getInstance(changeLogClass);
    }

    protected void processChangeLogInTransactionIfApplies(String executionId, String executionHostname, Object changeLogInstance, ChangeLogItem changeLog) {
        this.driver.getTransactioner().filter(c -> this.isDriverTransactional() && this.isStrategyPerChangeUnit() && changeLog.isTransactional()).orElse(new NonTransactioner()).executeInTransaction(() -> this.loopRawChangeSets(executionId, executionHostname, changeLogInstance, changeLog, changeLog.getChangeSetItems()));
    }

    protected void loopRawChangeSets(String executionId, String executionHostName, Object changeLogInstance, ChangeLogItem changeLog, List<? extends ChangeSetItem> changeSets) {
        for (ChangeSetItem changeSetItem : changeSets) {
            if (!this.isDriverTransactional() || this.isStrategyPerChangeUnit() && (changeSetItem.isBeforeChangeSets() || !changeLog.isTransactional())) {
                this.changeSetsToRollBack.push((Triple<Object, ChangeSetItem, Exception>)new Triple(changeLogInstance, (Object)changeSetItem, null));
            }
            this.processSingleChangeSet(executionId, executionHostName, changeLogInstance, changeSetItem);
        }
    }

    protected void rollbackProcessedChangeSetsIfApply(String executionId, String hostname, Deque<Triple<Object, ChangeSetItem, Exception>> processedChangeSets) {
        logger.info("Mongock migration aborted and DB transaction not enabled. Starting manual rollback process");
        processedChangeSets.forEach(triple -> {
            try {
                this.rollbackIfPresentAndTrackChangeEntry(executionId, hostname, triple.getFirst(), (ChangeSetItem)triple.getSecond(), (Exception)triple.getThird());
            }
            catch (Exception e) {
                throw e instanceof MongockException ? (MongockException)((Object)((Object)e)) : new MongockException((Throwable)e);
            }
        });
    }

    protected void processSingleChangeSet(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSet) {
        try {
            this.executeAndLogChangeSet(executionId, executionHostname, changeLogInstance, changeSet);
        }
        catch (Exception e) {
            this.processExceptionOnChangeSetExecution(e, changeSet, changeSet.isFailFast());
        }
    }

    protected String generateExecutionHostname(String executionId) {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            hostname = "unknown-host." + executionId;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.serviceIdentifier)) {
            hostname = hostname + "-";
            hostname = hostname + this.serviceIdentifier;
        }
        return hostname;
    }

    protected boolean isThereAnyChangeSetItemToBeExecuted(Collection<ChangeLogItem> changeLogs) {
        return changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).anyMatch(changeSetItem -> changeSetItem.isRunAlways() || !this.isAlreadyExecuted((ChangeSetItem)changeSetItem));
    }

    protected boolean isThereAnyChangeSetItemToBeRolledBack(Collection<ChangeLogItem> changeLogs) {
        return changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).anyMatch(this::isAlreadyExecuted);
    }

    protected boolean isAlreadyExecuted(ChangeSetItem changeSetItem) {
        return this.executedChangeEntries.stream().anyMatch(changeEntry -> changeEntry.getChangeId().equals(changeSetItem.getId()) && changeEntry.getAuthor().equals(changeSetItem.getAuthor()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeAndLogChangeSet(String executionId, String executionHostname, Object changelogInstance, ChangeSetItem changeSetItem) throws IllegalAccessException, InvocationTargetException {
        ChangeEntry changeEntry = null;
        boolean alreadyExecuted = false;
        ChangeType type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
        try {
            alreadyExecuted = this.isAlreadyExecuted(changeSetItem);
            if (!alreadyExecuted || changeSetItem.isRunAlways()) {
                logger.debug("executing changeSet[{}]", (Object)changeSetItem.getId());
                long executionTimeMillis = this.executeChangeSetMethod(changeSetItem.getMethod(), changelogInstance);
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, executionTimeMillis, ChangeState.EXECUTED, type);
                logger.debug("successfully executed changeSet[{}]", (Object)changeSetItem.getId());
            } else {
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, ChangeState.IGNORED, type);
            }
            if (changeEntry == null) return;
            this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
        }
        catch (Exception ex) {
            try {
                logger.debug("failure when executing changeSet[{}]", (Object)changeSetItem.getId());
                changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, ChangeState.FAILED, type, ex, null);
                throw ex;
            }
            catch (Throwable throwable) {
                if (changeEntry == null) throw throwable;
                this.logChangeEntry(changeEntry, changeSetItem, alreadyExecuted);
                try {
                    this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
                    throw throwable;
                }
                catch (Exception ex2) {
                    logger.debug("failure when tracking changeEntry[{}]", (Object)changeEntry.getId());
                }
                throw throwable;
            }
        }
        try {
            this.trackChangeEntry(changeSetItem, changeEntry, alreadyExecuted);
            return;
        }
        catch (Exception ex) {
            logger.debug("failure when tracking changeEntry[{}]", (Object)changeEntry.getId());
            return;
        }
    }

    private void trackChangeEntry(ChangeSetItem changeSetItem, ChangeEntry changeEntry, boolean alreadyExecuted) {
        if (!(changeSetItem.isRunAlways() && alreadyExecuted || changeEntry.getState() == ChangeState.IGNORED && !this.trackIgnored)) {
            this.driver.getChangeEntryService().saveOrUpdate(changeEntry);
        }
    }

    protected void rollbackIfPresentAndTrackChangeEntry(String executionId, String executionHostname, Object changeLogInstance, ChangeSetItem changeSetItem, Exception changeSetException) throws InvocationTargetException, IllegalAccessException {
        block5: {
            block4: {
                ChangeType type;
                if (!changeSetItem.getRollbackMethod().isPresent()) break block4;
                logger.debug("rolling back changeSet[{}]", (Object)changeSetItem.getId());
                Optional<Object> rollbackExceptionOpt = Optional.empty();
                try {
                    this.executeChangeSetMethod(changeSetItem.getRollbackMethod().get(), changeLogInstance);
                    logger.debug("successfully rolled back changeSet[{}]", (Object)changeSetItem.getId());
                    type = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                }
                catch (Exception ex2) {
                    try {
                        logger.debug("failure when rolling back changeSet[{}]:\n{}", (Object)changeSetItem.getId(), (Object)ex2.getMessage());
                        rollbackExceptionOpt = Optional.of(ex2);
                        throw ex2;
                    }
                    catch (Throwable throwable) {
                        ChangeType type2 = changeSetItem.isBeforeChangeSets() ? ChangeType.BEFORE_EXECUTION : ChangeType.EXECUTION;
                        ChangeState state = rollbackExceptionOpt.map(ex -> ChangeState.ROLLBACK_FAILED).orElse(ChangeState.ROLLED_BACK);
                        ChangeEntry changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, state, type2, changeSetException, rollbackExceptionOpt.orElse(null));
                        this.logChangeEntry(changeEntry, changeSetItem, false);
                        this.trackChangeEntry(changeSetItem, changeEntry, false);
                        throw throwable;
                    }
                }
                ChangeState state = rollbackExceptionOpt.map(ex -> ChangeState.ROLLBACK_FAILED).orElse(ChangeState.ROLLED_BACK);
                ChangeEntry changeEntry = this.buildChangeEntry(executionId, executionHostname, changeSetItem, -1L, state, type, changeSetException, rollbackExceptionOpt.orElse(null));
                this.logChangeEntry(changeEntry, changeSetItem, false);
                this.trackChangeEntry(changeSetItem, changeEntry, false);
                break block5;
            }
            logger.warn("ChangeSet[{}] does not provide rollback method", (Object)changeSetItem.getId());
        }
    }

    private void logChangeEntry(ChangeEntry changeEntry, ChangeSetItem changeSetItem, boolean alreadyExecuted) {
        switch (changeEntry.getState()) {
            case EXECUTED: {
                logger.info("{}APPLIED - {}", (Object)(alreadyExecuted ? "RE-" : ""), (Object)changeEntry.toPrettyString());
                break;
            }
            case IGNORED: {
                this.logIgnoredChangeSet(changeSetItem);
                break;
            }
            case FAILED: {
                logger.info("FAILED OVER - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLED_BACK: {
                logger.info("ROLLED BACK - {}", (Object)changeSetItem.toPrettyString());
                break;
            }
            case ROLLBACK_FAILED: {
                logger.info("ROLL BACK FAILED- {}", (Object)changeSetItem.toPrettyString());
            }
        }
    }

    protected void logIgnoredChangeSet(ChangeSetItem changeSetItem) {
        logger.info("PASSED OVER - {}", (Object)changeSetItem.toPrettyString());
    }

    protected void logIgnoredChangeLogs(Collection<ChangeLogItem> changeLogs) {
        changeLogs.stream().map(ChangeLogItem::getAllChangeItems).flatMap(Collection::stream).forEach(this::logIgnoredChangeSet);
    }

    protected ChangeEntry buildChangeEntry(String executionId, String executionHostname, ChangeSetItem changeSetItem, long executionTimeMillis, ChangeState state, ChangeType type) {
        return this.buildChangeEntry(executionId, executionHostname, changeSetItem, executionTimeMillis, state, type, null, null);
    }

    protected ChangeEntry buildChangeEntry(String executionId, String executionHostname, ChangeSetItem changeSetItem, long executionTimeMillis, ChangeState state, ChangeType type, Exception executionException, Exception rollbackException) {
        if (executionException == null && rollbackException == null) {
            return ChangeEntry.instance((String)executionId, (String)changeSetItem.getAuthor(), (ChangeState)state, (ChangeType)type, (String)changeSetItem.getId(), (String)changeSetItem.getMethod().getDeclaringClass().getName(), (String)changeSetItem.getMethod().getName(), (long)executionTimeMillis, (String)executionHostname, this.metadata, (Boolean)changeSetItem.isSystem());
        }
        HashMap<String, String> errorMap = new HashMap<String, String>();
        if (executionException != null) {
            errorMap.put("execution-error", StringUtils.getStackTrace((Throwable)executionException));
        }
        if (rollbackException != null) {
            errorMap.put("rollback-error", StringUtils.getStackTrace((Throwable)rollbackException));
        }
        return ChangeEntry.failedInstance((String)executionId, (String)changeSetItem.getAuthor(), (ChangeState)state, (ChangeType)type, (String)changeSetItem.getId(), (String)changeSetItem.getMethod().getDeclaringClass().getName(), (String)changeSetItem.getMethod().getName(), (long)executionTimeMillis, (String)executionHostname, this.metadata, (String)new Gson().toJson(errorMap), (Boolean)changeSetItem.isSystem());
    }

    protected long executeChangeSetMethod(Method changeSetMethod, Object changeLogInstance) throws IllegalAccessException, InvocationTargetException {
        long startingTime = System.currentTimeMillis();
        this.changeLogRuntime.runChangeSet(changeLogInstance, changeSetMethod);
        return System.currentTimeMillis() - startingTime;
    }

    protected void processExceptionOnChangeSetExecution(Exception exception, ChangeSetItem changeSetItem, boolean throwException) {
        String exceptionMsg = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException().getMessage() : exception.getMessage();
        Method method = changeSetItem.getMethod();
        String finalMessage = String.format("Error in method[%s.%s] : %s", method.getDeclaringClass().getSimpleName(), method.getName(), exceptionMsg);
        this.updateRollbackChangeSet(changeSetItem, exception);
        if (throwException) {
            throw new MongockException(finalMessage, exception);
        }
        logger.warn(finalMessage, (Throwable)exception);
    }

    private void updateRollbackChangeSet(ChangeSetItem changeSetItem, Exception exception) {
        Iterator<Triple<Object, ChangeSetItem, Exception>> iterator = this.changeSetsToRollBack.iterator();
        boolean finished = false;
        while (iterator.hasNext() && !finished) {
            Triple<Object, ChangeSetItem, Exception> item = iterator.next();
            if (!changeSetItem.getId().equals(((ChangeSetItem)item.getSecond()).getId())) continue;
            item.setThird((Object)exception);
            finished = true;
        }
    }

    protected void initializationAndValidation() throws MongockException {
        this.executionInProgress = true;
        this.driver.initialize();
        this.driver.runValidation();
        this.changeLogRuntime.initialize(this.driver.getLockManager());
        this.prepareChangeLogService();
    }

    private void injectDependenciesFromDriver() {
        this.changeLogRuntime.updateDriverDependencies(this.driver.getDependencies());
    }

    protected void loadExecutedChangeEntries() {
        this.executedChangeEntries = this.driver.getChangeEntryService().getExecuted();
    }

    protected final boolean isDriverTransactional() {
        return this.globalTransactionEnabled == null ? this.driver.isTransactionable() : this.globalTransactionEnabled != false && this.driver.isTransactionable();
    }

    protected final boolean isStrategyPerChangeUnit() {
        return this.transactionStrategy == null || this.transactionStrategy == TransactionStrategy.CHANGE_UNIT;
    }

    protected final boolean isStrategyPerMigration() {
        return this.transactionStrategy == TransactionStrategy.EXECUTION;
    }

    protected void prepareForStageExecutionIfApply(boolean applyPreparation) {
        if (applyPreparation && this.isDriverTransactional()) {
            this.driver.prepareForExecutionBlock();
        }
    }

    protected void clearChangeSetsToRollbackIfApply(boolean applyPreparation) {
        if (applyPreparation) {
            this.changeSetsToRollBack.clear();
        }
    }

    protected void prepareChangeLogService() {
        ArrayList changeLogsScanClasses = new ArrayList();
        ArrayList<String> changeLogsScanPackage = new ArrayList<String>();
        for (String itemPath : this.config.getMigrationScanPackage()) {
            try {
                changeLogsScanClasses.add(ClassLoader.getSystemClassLoader().loadClass(itemPath));
            }
            catch (ClassNotFoundException e) {
                changeLogsScanPackage.add(itemPath);
            }
        }
        this.changeLogService.reset();
        this.changeLogService.setDefaultAuthor(this.config.getDefaultAuthor());
        this.changeLogService.setChangeLogsBasePackageList(changeLogsScanPackage);
        this.changeLogService.setChangeLogsBaseClassList(changeLogsScanClasses);
        this.changeLogService.setStartSystemVersion(this.config.getStartSystemVersion());
        this.changeLogService.setEndSystemVersion(this.config.getEndSystemVersion());
        this.changeLogService.setProfileFilter(this.annotationFilter);
    }
}

