/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.core.executor;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.lock.LockCheckException;
import io.mongock.runner.core.event.EventPublisher;
import io.mongock.runner.core.event.result.MigrationSuccessResult;
import io.mongock.runner.core.executor.Executor;
import io.mongock.runner.core.executor.MongockRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongockRunnerImpl
implements MongockRunner {
    private static final Logger logger = LoggerFactory.getLogger(MongockRunnerImpl.class);
    private final Executor systemUpdateExecutor;
    private final Executor operationExecutor;
    private final boolean throwExceptionIfCannotObtainLock;
    private final EventPublisher eventPublisher;
    private boolean enabled;

    public MongockRunnerImpl(Executor systemUpdateExecutor, Executor operationExecutor, boolean throwExceptionIfCannotObtainLock, boolean enabled, EventPublisher eventPublisher) {
        this.systemUpdateExecutor = systemUpdateExecutor;
        this.operationExecutor = operationExecutor;
        this.enabled = enabled;
        this.throwExceptionIfCannotObtainLock = throwExceptionIfCannotObtainLock;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void forceEnable() {
        this.enabled = true;
    }

    @Override
    public boolean isExecutionInProgress() {
        return this.systemUpdateExecutor.isExecutionInProgress() || this.operationExecutor.isExecutionInProgress();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void execute() throws MongockException {
        if (!this.isEnabled()) {
            logger.info("Mongock is disabled. Exiting.");
        } else {
            try {
                this.eventPublisher.publishMigrationStarted();
                this.systemUpdateExecutor.executeMigration();
                Object result = this.operationExecutor.executeMigration();
                this.eventPublisher.publishMigrationSuccessEvent(new MigrationSuccessResult(result));
            }
            catch (LockCheckException lockEx) {
                MongockException mongockException = new MongockException((Throwable)lockEx);
                this.eventPublisher.publishMigrationFailedEvent((Exception)((Object)mongockException));
                if (this.throwExceptionIfCannotObtainLock) {
                    logger.error("Mongock did not acquire process lock. EXITING WITHOUT RUNNING OPERATION", (Throwable)lockEx);
                    throw mongockException;
                }
                logger.warn("Mongock did not acquire process lock. EXITING WITHOUT RUNNING OPERATION", (Throwable)lockEx);
            }
            catch (Exception ex) {
                MongockException exWrapper = MongockException.class.isAssignableFrom(ex.getClass()) ? (MongockException)((Object)ex) : new MongockException((Throwable)ex);
                logger.error("Error in mongock process. ABORTED OPERATION", (Throwable)exWrapper);
                this.eventPublisher.publishMigrationFailedEvent((Exception)((Object)exWrapper));
                throw exWrapper;
            }
        }
    }
}

