/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.springboot.base.config;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.runner.springboot.base.MongockApplicationRunner;
import io.mongock.runner.springboot.base.MongockInitializingBeanRunner;
import io.mongock.runner.springboot.base.builder.SpringApplicationBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;

public abstract class MongockContextBase<CONFIG extends MongockConfiguration> {
    @Bean
    @Profile(value={"!mongock-cli-profile"})
    @ConditionalOnExpression(value="'${mongock.runner-type:ApplicationRunner}'.toLowerCase().equals('applicationrunner')")
    public MongockApplicationRunner applicationRunner(ConnectionDriver connectionDriver, CONFIG springConfiguration, ApplicationContext springContext, ApplicationEventPublisher applicationEventPublisher) {
        return this.getBuilder(connectionDriver, springConfiguration, springContext, applicationEventPublisher).buildApplicationRunner();
    }

    @Bean
    @Profile(value={"!mongock-cli-profile"})
    @ConditionalOnExpression(value="'${mongock.runner-type:null}'.toLowerCase().equals('initializingbean')")
    public MongockInitializingBeanRunner initializingBeanRunner(ConnectionDriver connectionDriver, CONFIG springConfiguration, ApplicationContext springContext, ApplicationEventPublisher applicationEventPublisher) {
        return this.getBuilder(connectionDriver, springConfiguration, springContext, applicationEventPublisher).buildInitializingBeanRunner();
    }

    public abstract SpringApplicationBean getBuilder(ConnectionDriver var1, CONFIG var2, ApplicationContext var3, ApplicationEventPublisher var4);
}

