/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.test.template;

import com.mongodb.client.model.IndexOptions;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.mongodb.test.template.util.IntegrationTestBase;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class MongoChangeEntryRepositoryITestBase
extends IntegrationTestBase {
    protected ChangeEntryService repository;

    @Test
    public void shouldThrowException_WhenNoIndexCreation_IfIndexNoPreviouslyCreated() throws MongockException {
        MongockException ex = (MongockException)Assertions.assertThrows(MongockException.class, () -> this.initializeRepository(false));
        Assertions.assertEquals((Object)"Index creation not allowed, but not created or wrongly created for collection mongockChangeLog", (Object)ex.getMessage());
    }

    @Test
    public void shouldBeOk_WhenNoIndexCreation_IfIndexAlreadyCreated() throws MongockException {
        this.getDefaultAdapter().createIndex(this.getIndexDocument(new String[]{"executionId", "author", "changeId"}), new IndexOptions().unique(true));
        this.initializeRepository(false);
    }

    @Test
    public void getEntriesLog_WorksRegardlessOfExecutionMillisMissingIntegerOrLong() throws MongockException {
        this.initializeRepository(true);
        this.createAndInsertChangeEntry(false, null, "changeId1", "author", "executionId1", Long.MAX_VALUE);
        this.createAndInsertChangeEntry(false, null, "changeId2", "author", "executionId2", Integer.MAX_VALUE);
        this.createAndInsertChangeEntry(false, null, "changeId3", "author", "executionId3", null);
        List result = this.repository.getEntriesLog();
        Assertions.assertEquals((int)3, (int)result.size());
    }

    private void createAndInsertChangeEntry(boolean withState, String state, String changeId, String author, String executionId, Number executionMillis) {
        Document existingEntry = new Document().append("executionId", (Object)executionId).append("changeId", (Object)changeId).append("author", (Object)author).append("timestamp", (Object)Date.from(Instant.now())).append("executionMillis", (Object)executionMillis).append("changeLogClass", (Object)"anyClass").append("changeSetMethod", (Object)"anyMethod").append("metadata", null);
        if (withState) {
            existingEntry = existingEntry.append("state", (Object)state);
        }
        this.getDefaultAdapter().insertOne(existingEntry);
    }

    protected abstract void initializeRepository(boolean var1);

    protected Document getIndexDocument(String[] uniqueFields) {
        Document indexDocument = new Document();
        for (String field : uniqueFields) {
            indexDocument.append(field, (Object)1);
        }
        return indexDocument;
    }
}

