/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.test.template;

import com.github.cloudyrock.mongock.ChangeSet;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.core.driver.ConnectionDriverBase;
import io.mongock.driver.mongodb.test.template.integration.test1.withnorunalways.ChangeLogSuccess;
import io.mongock.driver.mongodb.test.template.integration.test1.withrunalways.WithRunAlways;
import io.mongock.driver.mongodb.test.template.integration.test2.ChangeLogFailure;
import io.mongock.driver.mongodb.test.template.integration.test3.ChangeLogEnsureDecorator;
import io.mongock.driver.mongodb.test.template.util.CallVerifier;
import io.mongock.driver.mongodb.test.template.util.CallVerifierImpl;
import io.mongock.driver.mongodb.test.template.util.IntegrationTestBase;
import io.mongock.driver.mongodb.test.template.util.MongoDBDriverTestAdapter;
import io.mongock.runner.core.executor.MongockRunner;
import io.mongock.runner.test.TestMongock;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class MongoDriverITestBase
extends IntegrationTestBase {
    protected static final String KEY_EXECUTION_ID = "executionId";
    protected static final String KEY_CHANGE_ID = "changeId";
    protected static final String KEY_AUTHOR = "author";
    protected static final String KEY_STATE = "state";
    protected static final String KEY_TIMESTAMP = "timestamp";
    protected static final String KEY_CHANGE_LOG_CLASS = "changeLogClass";
    protected static final String KEY_CHANGE_SET_METHOD = "changeSetMethod";
    protected static final String KEY_EXECUTION_MILLIS = "executionMillis";
    protected static final String KEY_METADATA = "metadata";
    public static final String ANY_EXECUTION_ID = "any";
    public static final String TEST_USER = "testuser";
    public static final String METHOD_PREFIX = "method_";

    @Test
    public void shouldRunAllChangeLogsSuccessfully() {
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), ChangeLogSuccess.class, "mongockChangeLog", Collections.emptyList(), false);
    }

    @Test
    public void shouldRegisterChangeSetAsIgnored_WhenAlreadyExecuted_IfNotRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        adapter.insertOne(this.getChangeEntryDocument(ChangeLogSuccess.class.getMethod("method_0", new Class[0]), ChangeState.EXECUTED));
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), ChangeLogSuccess.class, "mongockChangeLog", Collections.singletonList("method_0"), false);
    }

    @Test
    public void shouldRegisterChangeSetAsExecuted_WhenAlreadyExecuted_IfRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        Document changeEntry = this.getChangeEntryDocument(WithRunAlways.class.getMethod("method_0", new Class[0]), ChangeState.EXECUTED);
        adapter.insertOne(changeEntry);
        String executionId = UUID.randomUUID().toString();
        this.runChanges((ConnectionDriver)this.getDriverWithTransactionDisabled(), WithRunAlways.class, executionId);
        this.checkChanges(WithRunAlways.class, "mongockChangeLog", Collections.singletonList(changeEntry.getString((Object)KEY_CHANGE_ID)), false, executionId);
        MongoCollection collection = this.getDataBase().getCollection("mongockChangeLog");
        Assertions.assertNotNull((Object)collection.find((Bson)new Document().append(KEY_EXECUTION_ID, (Object)ANY_EXECUTION_ID).append(KEY_AUTHOR, (Object)TEST_USER).append(KEY_CHANGE_ID, (Object)"method_0")).first());
    }

    @Test
    public void shouldRegisterChangeSetAsExecuted_WhenAlreadyIgnored_IfNotRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        adapter.insertOne(this.getChangeEntryDocument(ChangeLogSuccess.class.getMethod("method_0", new Class[0]), ChangeState.IGNORED));
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), ChangeLogSuccess.class, "mongockChangeLog");
    }

    @Test
    public void shouldRegisterChangeSetAsExecuted_WhenAlreadyIgnored_IfRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        adapter.insertOne(this.getChangeEntryDocument(WithRunAlways.class.getMethod("method_0", new Class[0]), ChangeState.IGNORED));
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), WithRunAlways.class, "mongockChangeLog");
    }

    @Test
    public void shouldRegisterChangeSetAsExecuted_WhenAlreadyFailed_IfNotRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        adapter.insertOne(this.getChangeEntryDocument(ChangeLogSuccess.class.getMethod("method_0", new Class[0]), ChangeState.FAILED));
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), ChangeLogSuccess.class, "mongockChangeLog");
    }

    @Test
    public void shouldRegisterChangeSetAsExecuted_WhenAlreadyFailed_IfRunAlways() throws NoSuchMethodException {
        MongoDBDriverTestAdapter adapter = this.getDefaultAdapter();
        adapter.insertOne(this.getChangeEntryDocument(WithRunAlways.class.getMethod("method_0", new Class[0]), ChangeState.FAILED));
        this.runChangesAndCheck((ConnectionDriver)this.getDriverWithTransactionDisabled(), WithRunAlways.class, "mongockChangeLog");
    }

    @Test
    public void shouldUseDifferentChangeLogCollectionName_whenSettingChangeLogCollectionName() {
        String newChangeLogCollectionName = "newChangeLogCollectionName";
        ConnectionDriverBase driver = this.getDriverWithTransactionDisabled();
        driver.setChangeLogRepositoryName(newChangeLogCollectionName);
        this.runChangesAndCheck((ConnectionDriver)driver, ChangeLogSuccess.class, newChangeLogCollectionName, Collections.emptyList(), false);
    }

    private Document getChangeEntryDocument(Method method, ChangeState state) {
        ChangeSet changeSet = method.getAnnotation(ChangeSet.class);
        return new Document().append(KEY_EXECUTION_ID, (Object)ANY_EXECUTION_ID).append(KEY_CHANGE_ID, (Object)changeSet.id()).append(KEY_AUTHOR, (Object)changeSet.author()).append(KEY_STATE, (Object)state.name()).append(KEY_TIMESTAMP, (Object)new Date()).append(KEY_CHANGE_LOG_CLASS, (Object)method.getDeclaringClass().getName()).append(KEY_CHANGE_SET_METHOD, (Object)method.getName()).append(KEY_EXECUTION_MILLIS, (Object)0L).append(KEY_METADATA, this.getStringObjectMap());
    }

    @Test
    public void shouldFail_WhenRunningChangeLog_IfChangeSetIdDuplicated() {
        MongockException ex = (MongockException)Assertions.assertThrows(MongockException.class, () -> ((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)this.getDriverWithTransactionDisabled())).addChangeLogsScanPackage(ChangeLogFailure.class.getPackage().getName())).buildRunner().execute());
        Assertions.assertEquals((Object)"Duplicated changeset id found: 'id_duplicated'", (Object)ex.getMessage());
    }

    @Test
    public void shouldPassMongoDatabaseDecoratorToChangeSet() {
        CallVerifierImpl callVerifier = new CallVerifierImpl();
        ((TestMongock.Builder)((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)this.getDriverWithTransactionDisabled())).addChangeLogsScanPackage(ChangeLogEnsureDecorator.class.getPackage().getName())).addDependency(CallVerifier.class, (Object)callVerifier)).buildRunner().execute();
        Assertions.assertEquals((int)1, (int)callVerifier.getCounter());
    }

    @Test
    public void shouldPrioritizeConnectorOverStandardDependencies_WhenThereIsConflict() {
        CallVerifierImpl callVerifier = new CallVerifierImpl();
        ((TestMongock.Builder)((TestMongock.Builder)((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)this.getDriverWithTransactionDisabled())).addChangeLogsScanPackage(ChangeLogEnsureDecorator.class.getPackage().getName())).addDependency(CallVerifier.class, (Object)callVerifier)).addDependency(MongoDatabase.class, Mockito.mock(MongoDatabase.class))).buildRunner().execute();
        Assertions.assertEquals((int)1, (int)callVerifier.getCounter());
    }

    @Test
    public void shouldThrowException_WhenNotIndexCreation_IfNotCreatedBefore() {
        ConnectionDriverBase driver = this.getDriverWithTransactionDisabled();
        driver.setIndexCreation(false);
        MongockException ex = (MongockException)Assertions.assertThrows(MongockException.class, () -> ((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)driver)).addChangeLogsScanPackage(ChangeLogSuccess.class.getPackage().getName())).buildRunner().execute());
        Assertions.assertEquals((Object)"Index creation not allowed, but not created or wrongly created for collection mongockLock", (Object)ex.getMessage());
    }

    @Test
    public void shouldBeOk_WhenNotIndexCreation_IfCreatedBefore() {
        ConnectionDriverBase driver = this.getDriverWithTransactionDisabled();
        driver.setIndexCreation(false);
        this.getAdapter("mongockChangeLog").createUniqueIndex(KEY_EXECUTION_ID, KEY_AUTHOR, KEY_CHANGE_ID);
        driver.setLockRepositoryName("mongockLock");
        this.getAdapter("mongockLock").createUniqueIndex("key");
        ((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)driver)).addChangeLogsScanPackage(ChangeLogSuccess.class.getPackage().getName())).buildRunner().execute();
    }

    @Test
    public void shouldThrowException_WhenNotIndexCreation_IfWrongLockIndexCreated() {
        ConnectionDriverBase driver = this.getDriverWithTransactionDisabled();
        driver.setIndexCreation(false);
        this.getAdapter("mongockChangeLog").createUniqueIndex(KEY_EXECUTION_ID, KEY_AUTHOR, KEY_CHANGE_ID);
        driver.setLockRepositoryName("mongockLock");
        this.getAdapter("mongockLock").createUniqueIndex("keywrong");
        MongockException ex = (MongockException)Assertions.assertThrows(MongockException.class, () -> ((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)driver)).addChangeLogsScanPackage(ChangeLogSuccess.class.getPackage().getName())).buildRunner().execute());
        Assertions.assertEquals((Object)"Index creation not allowed, but not created or wrongly created for collection mongockLock", (Object)ex.getMessage());
    }

    @Test
    public void shouldThrowException_WhenNotIndexCreation_IfChangeLogIndexPartiallyCreated() {
        ConnectionDriverBase driver = this.getDriverWithTransactionDisabled();
        driver.setIndexCreation(false);
        this.getAdapter("mongockChangeLog").createUniqueIndex("executionId_wrong", KEY_AUTHOR, KEY_CHANGE_ID);
        driver.setLockRepositoryName("mongockLock");
        this.getAdapter("mongockLock").createUniqueIndex("key");
        MongockException ex = (MongockException)Assertions.assertThrows(MongockException.class, () -> ((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver((ConnectionDriver)driver)).addChangeLogsScanPackage(ChangeLogSuccess.class.getPackage().getName())).buildRunner().execute());
        Assertions.assertEquals((Object)"Index creation not allowed, but not created or wrongly created for collection mongockChangeLog", (Object)ex.getMessage());
    }

    private void runChangesAndCheck(ConnectionDriver driver, Class changeLogClass, String changeLogCollectionName) {
        this.runChangesAndCheck(driver, changeLogClass, changeLogCollectionName, Collections.emptyList(), false);
    }

    private void runChangesAndCheck(ConnectionDriver driver, Class changeLogClass, String chageLogCollectionName, Collection<String> ignoredChangeIds, boolean trackIgnored) {
        String executionId = UUID.randomUUID().toString();
        this.runChanges(driver, changeLogClass, executionId);
        this.checkChanges(changeLogClass, chageLogCollectionName, ignoredChangeIds, trackIgnored, executionId);
    }

    private void checkChanges(Class changeLogClass, String chageLogCollectionName, Collection<String> ignoredOrRunAlwaysChangeIds, boolean trackIgnored, String executionId) {
        MongoCollection collection = this.getDataBase().getCollection(chageLogCollectionName);
        for (int i = 0; i < 5; ++i) {
            Document change = (Document)collection.find((Bson)new Document().append(KEY_EXECUTION_ID, (Object)executionId).append(KEY_AUTHOR, (Object)TEST_USER).append(KEY_CHANGE_ID, (Object)(METHOD_PREFIX + i))).first();
            if (!trackIgnored && ignoredOrRunAlwaysChangeIds.contains(METHOD_PREFIX + i)) continue;
            String executionIdChange = (String)change.get((Object)KEY_EXECUTION_ID, String.class);
            String changeId = (String)change.get((Object)KEY_CHANGE_ID, String.class);
            String author = (String)change.get((Object)KEY_AUTHOR, String.class);
            String state = (String)change.get((Object)KEY_STATE, String.class);
            Date timestamp = (Date)change.get((Object)KEY_TIMESTAMP, Date.class);
            String changeLogClassInstance = (String)change.get((Object)KEY_CHANGE_LOG_CLASS, String.class);
            String changeSetMethod = (String)change.get((Object)KEY_CHANGE_SET_METHOD, String.class);
            Long executionMillis = (Long)change.get((Object)KEY_EXECUTION_MILLIS, Long.class);
            Map metadataResult = (Map)change.get((Object)KEY_METADATA, Map.class);
            Assertions.assertNotNull((Object)executionIdChange);
            Assertions.assertEquals((Object)(METHOD_PREFIX + i), (Object)changeId);
            Assertions.assertEquals((Object)TEST_USER, (Object)author);
            Assertions.assertEquals((Object)(ignoredOrRunAlwaysChangeIds.contains(changeId) ? ChangeState.IGNORED : ChangeState.EXECUTED).name(), (Object)state);
            Assertions.assertNotNull((Object)timestamp);
            Assertions.assertEquals((Object)changeLogClass.getName(), (Object)changeLogClassInstance);
            Assertions.assertEquals((Object)(METHOD_PREFIX + i), (Object)changeSetMethod);
            Assertions.assertNotNull((Object)executionMillis);
            this.checkMetadata(metadataResult);
        }
    }

    private void runChanges(ConnectionDriver driver, Class changeLogClass, String executionId) {
        MongockRunner runner = ((TestMongock.Builder)((TestMongock.Builder)((TestMongock.Builder)((TestMongock.Builder)TestMongock.builder().setDriver(driver)).addChangeLogsScanPackage(changeLogClass.getPackage().getName())).withMetadata(this.getStringObjectMap())).setExecutionId(executionId)).buildRunner();
        runner.execute();
    }

    private Map<String, Object> getStringObjectMap() {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("string_key", "string_value");
        metadata.put("integer_key", 10);
        metadata.put("float_key", Float.valueOf(11.11f));
        metadata.put("double_key", 12.12);
        metadata.put("long_key", 13L);
        metadata.put("boolean_key", true);
        return metadata;
    }

    private void checkMetadata(Map metadataResult) {
        Assertions.assertEquals((Object)"string_value", metadataResult.get("string_key"));
        Assertions.assertEquals((Object)10, metadataResult.get("integer_key"));
        Assertions.assertEquals((double)11.11f, (double)((Double)metadataResult.get("float_key")), (double)0.01);
        Assertions.assertEquals((double)12.12, (double)((Double)metadataResult.get("double_key")), (double)0.01);
        Assertions.assertEquals((Object)13L, metadataResult.get("long_key"));
        Assertions.assertEquals((Object)true, metadataResult.get("boolean_key"));
    }

    protected abstract ConnectionDriverBase getDriverWithTransactionDisabled();
}

