/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.test.template;

import com.mongodb.client.FindIterable;
import com.mongodb.client.model.UpdateOptions;
import io.mongock.driver.api.lock.LockCheckException;
import io.mongock.driver.api.lock.LockManager;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockManagerDefault;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.driver.mongodb.test.template.util.IntegrationTestBase;
import io.mongock.utils.TimeService;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class MongoLockManagerITestBase
extends IntegrationTestBase {
    protected static final String LOCK_COLLECTION_NAME = "mongockLock";
    protected static final long LOCK_ACQUIRED_FOR_MILLIS = 300000L;
    protected static final long LOCK_QUIT_TRYING_AFTER_MILLIS = 900000L;
    protected static final long LOCK_TRY_FRQUENCY_MILLIS = 1000L;
    protected LockManager lockManager;
    protected LockRepositoryWithEntity<Document> repository;

    @BeforeEach
    public void setUp() {
        this.initializeRepository();
    }

    private void getLockManager(TimeService timeService, long acquireForMillis, long tryFreq, long quickTrying) {
        this.lockManager = LockManagerDefault.builder().setLockRepository(this.repository).setTimeService(timeService).setLockAcquiredForMillis(acquireForMillis).setLockTryFrequencyMillis(tryFreq).setLockQuitTryingAfterMillis(quickTrying).build();
    }

    @AfterEach
    public void tearDown() {
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).deleteMany((Bson)new Document());
    }

    @Test
    public void shouldAcquireLock_WhenHeld_IfSameOwner() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 900000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody(this.lockManager.getOwner(), this.currentTimePlusHours(24))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.acquireLockDefault();
    }

    @Test
    public void shouldAcquireLock_WhenHeldByOther_IfExpired() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 900000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("otherOwner", this.currentTimePlusHours(-1))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.acquireLockDefault();
    }

    @Test
    public void shouldFinallyAcquireLock_WhenTheLockIsHeldByOther_IfTheTimeItWIllBeReTryingIsLongerThanTheCurrentLockExpireTime() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 900000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("otherOwner", System.currentTimeMillis() + 100L)), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.acquireLockDefault();
    }

    @Test
    public void shouldNotAcquireLock_WhenHeldByOther_IfExpiresAtIsGreaterThanMaxWaitTime() throws LockCheckException {
        long acquireFor = 3000L;
        this.getLockManager(new TimeService(), acquireFor, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("otherOwner", this.currentTimePlusMinutes(1))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        Assertions.assertThrows(LockCheckException.class, () -> this.lockManager.acquireLockDefault());
    }

    @Test
    public void shouldThrowException_WhenEnsuring_IfNotAcquiredFirst() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        Assertions.assertThrows(LockCheckException.class, () -> this.lockManager.ensureLockDefault());
    }

    @Test
    public void shouldEnsureLock_WhenHeldBySame_IfNotExpiredInDB() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody(this.lockManager.getOwner(), this.currentTimePlusMinutes(1))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.ensureLockDefault();
    }

    @Test
    public void shouldEnsureLock_WhenHeldBySame_IfExpiredInDB() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody(this.lockManager.getOwner(), this.currentTimePlusMinutes(-10))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.ensureLockDefault();
    }

    @Test
    public void shouldEnsureLock_WhenAcquiredPreviously_IfSameOwner() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        this.lockManager.acquireLockDefault();
        this.lockManager.ensureLockDefault();
    }

    @Test
    public void shouldNotEnsureLock_WhenHeldByOtherAndExpiredInDB_ifHasNotBeenRequestedPreviously() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("other", this.currentTimePlusMinutes(-10))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        Assertions.assertThrows(LockCheckException.class, () -> this.lockManager.ensureLockDefault());
    }

    @Test
    public void shouldNotEnsureLock_WhenHeldByOther_IfNotExpiredInDB() throws LockCheckException {
        this.getLockManager(new TimeService(), 300000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("other", this.currentTimePlusMinutes(10))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        Assertions.assertThrows(LockCheckException.class, () -> this.lockManager.ensureLockDefault());
    }

    @Test
    public void shouldReleaseLock_WhenHeldBySameOwner() {
        this.getLockManager(new TimeService(), 3000L, 1000L, 1000L);
        this.lockManager.acquireLockDefault();
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.releaseLockDefault();
        FindIterable resultAfter = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNull((Object)resultAfter.first(), (String)"Lock should be removed from DB");
    }

    @Test
    public void shouldNotReleaseLock_IfHeldByOtherOwner() {
        this.getLockManager(new TimeService(), 3000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("otherOwner", this.currentTimePlusMinutes(10))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.releaseLockDefault();
        FindIterable resultAfter = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultAfter.first(), (String)"Lock should be removed from DB");
    }

    @Test
    public void releaseLockShouldBeIdempotent_WhenHeldBySameOwner() {
        this.getLockManager(new TimeService(), 3000L, 3000L, 1000L);
        this.lockManager.acquireLockDefault();
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.releaseLockDefault();
        this.lockManager.releaseLockDefault();
        FindIterable resultAfter = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNull((Object)resultAfter.first(), (String)"Lock should be removed from DB");
    }

    @Test
    public void releaseLockShouldBeIdempotent_WhenHeldByOtherOwner() {
        this.getLockManager(new TimeService(), 3000L, 1000L, 1000L);
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", (Object)this.getLockDbBody("otherOwner", this.currentTimePlusMinutes(10))), new UpdateOptions().upsert(true));
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultBefore.first(), (String)"Precondition: Lock should be in database");
        this.lockManager.releaseLockDefault();
        this.lockManager.releaseLockDefault();
        FindIterable resultAfter = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)this.lockManager.getDefaultKey()));
        Assertions.assertNotNull((Object)resultAfter.first(), (String)"Lock should be removed from DB");
    }

    @Test
    public void releaseLockShouldNotThrowAnyException_WhenLockNoPresent() {
        this.getLockManager(new TimeService(), 3000L, 1000L, 1000L);
        FindIterable resultBefore = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find();
        Assertions.assertNull((Object)resultBefore.first(), (String)"Precondition: Lock should not be in database");
        this.lockManager.releaseLockDefault();
        FindIterable resultAfter = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find();
        Assertions.assertNull((Object)resultAfter.first(), (String)"Lock should be removed from DB");
    }

    private Document getLockDbBody(String owner, long expiresAt) {
        LockEntry lockEntry = new LockEntry(this.lockManager.getDefaultKey(), LockStatus.LOCK_HELD.name(), owner, new Date(expiresAt));
        return (Document)this.repository.toEntity((Object)lockEntry);
    }

    private long currentTimePlusHours(int hours) {
        return this.currentTimePlusMinutes(hours * 60);
    }

    private long currentTimePlusMinutes(int minutes) {
        long millis = minutes * 60 * 1000;
        return System.currentTimeMillis() + millis;
    }

    private int millisToMinutes(long millis) {
        return (int)(millis / 60000L);
    }

    protected abstract void initializeRepository();
}

