/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.test.template;

import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.UpdateOptions;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockPersistenceException;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.driver.mongodb.test.template.interfaces.MongoLockRepositoryITestInterface;
import io.mongock.driver.mongodb.test.template.util.IntegrationTestBase;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class MongoLockRepositoryITestBase
extends IntegrationTestBase
implements MongoLockRepositoryITestInterface {
    private static final String LOCK_COLLECTION_NAME = "mongockLock";
    private static final String LOCK_KEY = "LOCK_KEY";
    protected LockRepositoryWithEntity<Document> repository;

    @Override
    @Test
    public void ensureKeyUniqueness() {
        this.initializeRepository();
        this.getAdapter(LOCK_COLLECTION_NAME).insertOne((Document)this.repository.toEntity((Object)new LockEntry("KEY1", "STATUS1", "process1", new Date(System.currentTimeMillis() - 60000L))));
        this.getAdapter(LOCK_COLLECTION_NAME).insertOne((Document)this.repository.toEntity((Object)new LockEntry("KEY2", "STATUS1", "process1", new Date(System.currentTimeMillis() - 60000L))));
        try {
            this.getAdapter(LOCK_COLLECTION_NAME).insertOne((Document)this.repository.toEntity((Object)new LockEntry("KEY1", "STATUS2", "process2", new Date(System.currentTimeMillis() - 60000L))));
        }
        catch (MongoWriteException ex) {
            Assertions.assertEquals((Object)ErrorCategory.DUPLICATE_KEY, (Object)ex.getError().getCategory());
        }
    }

    @Override
    @Test
    public void findByKeyShouldReturnLockWhenThereIsOne() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", this.repository.toEntity((Object)new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() - 60000L)))), new UpdateOptions().upsert(true));
        LockEntry result = this.repository.findByKey(LOCK_KEY);
        Assertions.assertNotNull((Object)result);
    }

    @Override
    @Test
    public void insertUpdateShouldInsertWhenEmpty() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        Date expiresAtExpected = new Date(System.currentTimeMillis() - 60000L);
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", expiresAtExpected));
        FindIterable result = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY));
        Assertions.assertNotNull((Object)result.first());
        Assertions.assertEquals((Object)expiresAtExpected, (Object)((Document)result.first()).get((Object)"expiresAt"));
    }

    @Override
    @Test
    public void insertUpdateShouldUpdateWhenExpiresAtIsGraterThanSaved() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        long currentMillis = System.currentTimeMillis();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(currentMillis - 1000L)));
        Date expiresAtExpected = new Date();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process2", expiresAtExpected));
        FindIterable result = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY));
        Assertions.assertNotNull((Object)result.first());
        Assertions.assertEquals((Object)expiresAtExpected, (Object)((Document)result.first()).get((Object)"expiresAt"));
    }

    @Override
    @Test
    public void insertUpdateShouldUpdateWhenSameOwner() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() + 3600000L)));
        Date expiresAtExpected = new Date();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", expiresAtExpected));
        FindIterable result = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY));
        Assertions.assertNotNull((Object)result.first());
        Assertions.assertEquals((Object)expiresAtExpected, (Object)((Document)result.first()).get((Object)"expiresAt"));
    }

    @Override
    @Test
    public void insertUpdateShouldThrowExceptionWhenLockIsInDBWIthDifferentOwnerAndNotExpired() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        long currentMillis = System.currentTimeMillis();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(currentMillis + 3600000L)));
        Assertions.assertThrows(LockPersistenceException.class, () -> this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process2", new Date(currentMillis + 5400000L))));
    }

    @Override
    @Test
    public void removeShouldRemoveWhenSameOwner() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", this.repository.toEntity((Object)new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() - 600000L)))), new UpdateOptions().upsert(true));
        Assertions.assertNotNull((Object)this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY)).first(), (String)"Precondition: Lock should be in getDataBase()");
        this.repository.removeByKeyAndOwner(LOCK_KEY, "process1");
        Assertions.assertNull((Object)this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY)).first());
    }

    @Override
    @Test
    public void removeShouldNotRemoveWhenDifferentOwner() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        this.getDataBase().getCollection(LOCK_COLLECTION_NAME).updateMany((Bson)new Document(), (Bson)new Document().append("$set", this.repository.toEntity((Object)new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() - 600000L)))), new UpdateOptions().upsert(true));
        Assertions.assertNotNull((Object)this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY)).first(), (String)"Precondition: Lock should be in getDataBase()");
        this.repository.removeByKeyAndOwner(LOCK_KEY, "process2");
        Assertions.assertNotNull((Object)this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY)).first());
    }

    @Override
    @Test
    public void updateIfSameOwnerShouldNotInsertWhenEmpty() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        Assertions.assertThrows(LockPersistenceException.class, () -> this.repository.updateIfSameOwner(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() - 600000L))));
    }

    @Override
    @Test
    public void updateIfSameOwnerShouldNotUpdateWhenExpiresAtIsGraterThanSavedButOtherOwner() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        long currentMillis = System.currentTimeMillis();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(currentMillis - 1000L)));
        Assertions.assertThrows(LockPersistenceException.class, () -> this.repository.updateIfSameOwner(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process2", new Date(currentMillis))));
    }

    @Override
    @Test
    public void updateIfSameOwnerShouldUpdateWhenSameOwner() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(System.currentTimeMillis() + 3600000L)));
        Date expiresAtExpected = new Date(System.currentTimeMillis());
        this.repository.updateIfSameOwner(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", expiresAtExpected));
        FindIterable result = this.getDataBase().getCollection(LOCK_COLLECTION_NAME).find((Bson)new Document().append("key", (Object)LOCK_KEY));
        Assertions.assertNotNull((Object)result.first());
        Assertions.assertEquals((Object)expiresAtExpected, (Object)((Document)result.first()).get((Object)"expiresAt"));
    }

    @Override
    @Test
    public void updateIfSameOwnerShouldNotUpdateWhenDifferentOwnerAndExpiresAtIsNotGrater() throws LockPersistenceException, MongockException {
        this.initializeRepository();
        long currentMillis = System.currentTimeMillis();
        this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process1", new Date(currentMillis + 3600000L)));
        Assertions.assertThrows(LockPersistenceException.class, () -> this.repository.insertUpdate(new LockEntry(LOCK_KEY, LockStatus.LOCK_HELD.name(), "process2", new Date(currentMillis))));
    }
}

