/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.repository;

import com.mongodb.client.model.IndexOptions;
import com.mongodb.reactivestreams.client.MongoCollection;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.common.EntityRepository;
import io.mongock.driver.api.common.RepositoryIndexable;
import io.mongock.driver.mongodb.reactive.repository.ReadWriteConfiguration;
import io.mongock.driver.mongodb.reactive.util.MongoCollectionSync;
import io.mongock.driver.mongodb.reactive.util.MongoSubscriberSync;
import io.mongock.utils.field.FieldInstance;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoReactiveRepositoryBase<DOMAIN_CLASS>
implements EntityRepository<DOMAIN_CLASS, Document>,
RepositoryIndexable {
    private static final Logger logger = LoggerFactory.getLogger(MongoReactiveRepositoryBase.class);
    private static final int INDEX_ENSURE_MAX_TRIES = 3;
    private final String[] uniqueFields;
    private boolean indexCreation = true;
    private boolean ensuredCollectionIndex = false;
    protected MongoCollectionSync collection;

    public MongoReactiveRepositoryBase(MongoCollection<Document> collection, String[] uniqueFields, ReadWriteConfiguration readWriteConfiguration) {
        MongoCollection enhancedCollection = collection.withReadConcern(readWriteConfiguration.getReadConcern()).withReadPreference(readWriteConfiguration.getReadPreference()).withWriteConcern(readWriteConfiguration.getWriteConcern());
        this.collection = new MongoCollectionSync((MongoCollection<Document>)enhancedCollection);
        this.uniqueFields = uniqueFields;
    }

    public synchronized void initialize() {
        if (!this.ensuredCollectionIndex) {
            this.ensureIndex(3);
            this.ensuredCollectionIndex = true;
        }
    }

    private void ensureIndex(int tryCounter) {
        if (tryCounter <= 0) {
            throw new MongockException("Max tries 3 index  creation");
        }
        if (!this.isIndexFine()) {
            if (!this.indexCreation) {
                throw new MongockException("Index creation not allowed, but not created or wrongly created for collection " + this.collection.getNamespace().getCollectionName());
            }
            this.cleanResidualUniqueKeys();
            if (!this.isRequiredIndexCreated()) {
                this.createRequiredUniqueIndex();
            }
            this.ensureIndex(tryCounter - 1);
        }
    }

    protected boolean isIndexFine() {
        return this.getResidualKeys().isEmpty() && this.isRequiredIndexCreated();
    }

    protected void cleanResidualUniqueKeys() {
        logger.debug("Removing residual uniqueKeys for collection [{}]", (Object)this.getCollectionName());
        this.getResidualKeys().stream().peek(index -> logger.debug("Removed residual uniqueKey [{}] for collection [{}]", (Object)index.toString(), (Object)this.getCollectionName())).forEach(this::dropIndex);
    }

    private List<Document> getResidualKeys() {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        return this.collection.listIndexes().stream().filter(this::doesNeedToBeRemoved).collect(Collectors.toList());
    }

    protected boolean doesNeedToBeRemoved(Document index) {
        return !this.isIdIndex(index) && this.isUniqueIndex(index) && !this.isRightIndex(index);
    }

    protected boolean isIdIndex(Document index) {
        return ((Document)index.get((Object)"key")).get((Object)"_id") != null;
    }

    protected boolean isRequiredIndexCreated() {
        MongoSubscriberSync subscriber = new MongoSubscriberSync();
        return this.collection.listIndexes().stream().anyMatch(this::isRightIndex);
    }

    protected void createRequiredUniqueIndex() {
        this.collection.createIndex((Bson)this.getIndexDocument(this.uniqueFields), new IndexOptions().unique(true));
        logger.debug("Index in collection [{}] was recreated", (Object)this.getCollectionName());
    }

    protected boolean isRightIndex(Document index) {
        Document key = (Document)index.get((Object)"key");
        boolean keyContainsAllFields = Stream.of(this.uniqueFields).allMatch(uniqueField -> key.get(uniqueField) != null);
        boolean onlyTheseFields = key.size() == this.uniqueFields.length;
        return keyContainsAllFields && onlyTheseFields && this.isUniqueIndex(index);
    }

    protected boolean isUniqueIndex(Document index) {
        return index.getBoolean((Object)"unique", false);
    }

    private String getCollectionName() {
        return this.collection.getNamespace().getCollectionName();
    }

    protected Document getIndexDocument(String[] uniqueFields) {
        Document indexDocument = new Document();
        Stream.of(uniqueFields).forEach(field -> indexDocument.append(field, (Object)1));
        return indexDocument;
    }

    protected void dropIndex(Document index) {
        this.collection.dropIndex(index.get((Object)"name").toString());
    }

    public Document mapFieldInstances(List<FieldInstance> fieldInstanceList) {
        Document document = new Document();
        fieldInstanceList.forEach(def -> document.append(def.getName(), def.getValue()));
        return document;
    }

    public void setIndexCreation(boolean indexCreation) {
        this.indexCreation = indexCreation;
    }
}

