/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.util;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.mongodb.reactive.util.MongoIterable;
import io.mongock.driver.mongodb.reactive.util.SubscriberSync;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscription;

public class MongoSubscriberSync<T>
implements SubscriberSync<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final MongoIterable<T> items = new MongoIterable();
    private Throwable error = null;
    private Subscription subscription;
    private boolean completed = false;

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
    }

    public void onNext(T t) {
        this.items.add(t);
    }

    public void onError(Throwable error) {
        this.error = error;
        this.latch.countDown();
    }

    public void onComplete() {
        this.completed = true;
        this.latch.countDown();
    }

    @Override
    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public MongoIterable<T> get(long timeoutMS) {
        return this.await((long)timeoutMS).items;
    }

    @Override
    public MongoSubscriberSync<T> await(long timeout) {
        return this.await(timeout, true);
    }

    protected MongoSubscriberSync<T> await(long timeout, boolean request) {
        boolean await;
        if (request) {
            this.subscription.request(Long.MAX_VALUE);
        }
        try {
            await = this.latch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new MongockException((Throwable)e);
        }
        if (!await) {
            throw new MongockException(this.getClass().getSimpleName() + " publisher onComplete timed out");
        }
        if (this.error != null) {
            if (RuntimeException.class.isAssignableFrom(this.error.getClass())) {
                throw (RuntimeException)this.error;
            }
            throw new MongockException(this.error);
        }
        return this;
    }
}

