/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.reactive.driver;

import com.mongodb.reactivestreams.client.MongoClient;
import io.mongock.driver.mongodb.reactive.driver.MongoReactiveDriverBase;
import io.mongock.utils.Constants;
import io.mongock.utils.TimeService;
import io.mongock.utils.annotation.NotThreadSafe;

@NotThreadSafe
public class MongoReactiveDriver
extends MongoReactiveDriverBase {
    protected MongoReactiveDriver(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    public static MongoReactiveDriver withDefaultLock(MongoClient mongoClient, String databaseName) {
        return MongoReactiveDriver.withLockStrategy(mongoClient, databaseName, Constants.DEFAULT_LOCK_ACQUIRED_FOR_MILLIS, Constants.DEFAULT_QUIT_TRYING_AFTER_MILLIS, Constants.DEFAULT_TRY_FREQUENCY_MILLIS);
    }

    public static MongoReactiveDriver withLockStrategy(MongoClient mongoClient, String databaseName, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        return new MongoReactiveDriver(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
    }

    @Deprecated
    public static MongoReactiveDriver withLockSetting(MongoClient mongoClient, String databaseName, long lockAcquiredForMinutes, long maxWaitingForLockMinutes, int maxTries) {
        TimeService timeService = new TimeService();
        long lockAcquiredForMillis = timeService.minutesToMillis(lockAcquiredForMinutes);
        long lockQuitTryingAfterMillis = timeService.minutesToMillis(maxWaitingForLockMinutes * (long)maxTries);
        long tryFrequency = 1000L;
        return MongoReactiveDriver.withLockStrategy(mongoClient, databaseName, lockAcquiredForMillis, lockQuitTryingAfterMillis, tryFrequency);
    }
}

