/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v3;

import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.core.entry.ChangeEntryRepositoryWithEntity;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4ChangeEntryRepository;
import io.mongock.driver.mongodb.sync.v4.repository.ReadWriteConfiguration;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

public class SpringDataMongoV3ChangeEntryRepository
extends MongoSync4ChangeEntryRepository
implements ChangeEntryRepositoryWithEntity<Document> {
    private final MongoOperations mongoOperations;
    private final boolean transactionable;

    public SpringDataMongoV3ChangeEntryRepository(MongoOperations mongoOperations, String collectionName, ReadWriteConfiguration readWriteConfiguration, boolean transactionable) {
        super(mongoOperations.getCollection(collectionName), readWriteConfiguration);
        this.mongoOperations = mongoOperations;
        this.transactionable = transactionable;
    }

    public void saveOrUpdate(ChangeEntry changeEntry) throws MongockException {
        if (this.transactionable) {
            Query filter = new Query().addCriteria((CriteriaDefinition)new Criteria().andOperator(new Criteria[]{Criteria.where((String)KEY_EXECUTION_ID).is((Object)changeEntry.getExecutionId()), Criteria.where((String)KEY_CHANGE_ID).is((Object)changeEntry.getChangeId()), Criteria.where((String)KEY_AUTHOR).is((Object)changeEntry.getAuthor())}));
            this.mongoOperations.upsert(filter, (UpdateDefinition)this.getUpdateFromEntity(changeEntry), this.collection.getNamespace().getCollectionName());
        } else {
            super.saveOrUpdate(changeEntry);
        }
    }

    private Update getUpdateFromEntity(ChangeEntry changeEntry) {
        Update updateChangeEntry = new Update();
        ((Document)this.toEntity(changeEntry)).forEach((arg_0, arg_1) -> ((Update)updateChangeEntry).set(arg_0, arg_1));
        return updateChangeEntry;
    }
}

