/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.springdata.v3;

import com.github.cloudyrock.mongock.driver.mongodb.springdata.v3.decorator.impl.MongockTemplate;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ChangeSetDependency;
import io.mongock.driver.api.driver.ChangeSetDependencyBuildable;
import io.mongock.driver.api.driver.Transactional;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.mongodb.springdata.v3.SpringDataMongoV3ChangeEntryRepository;
import io.mongock.driver.mongodb.sync.v4.driver.MongoSync4DriverGeneric;
import io.mongock.utils.annotation.NotThreadSafe;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@NotThreadSafe
public abstract class SpringDataMongoV3DriverBase
extends MongoSync4DriverGeneric {
    protected static final Logger logger = LoggerFactory.getLogger(SpringDataMongoV3DriverBase.class);
    protected final MongoTemplate mongoTemplate;
    protected MongoTransactionManager txManager;

    protected SpringDataMongoV3DriverBase(MongoTemplate mongoTemplate, long lockAcquiredForMillis, long lockQuitTryingAfterMillis, long lockTryFrequencyMillis) {
        super(mongoTemplate.getDb(), lockAcquiredForMillis, lockQuitTryingAfterMillis, lockTryFrequencyMillis);
        this.mongoTemplate = mongoTemplate;
        this.disableTransaction();
    }

    public void runValidation() throws MongockException {
        super.runValidation();
        if (this.mongoTemplate == null) {
            throw new MongockException("MongoTemplate must not be null");
        }
    }

    public void specificInitialization() {
        super.specificInitialization();
        this.dependencies.add(new ChangeSetDependencyBuildable(MongockTemplate.class, MongoTemplate.class, impl -> new MongockTemplate((MongoTemplate)impl), true));
        this.dependencies.add(new ChangeSetDependency(MongoTemplate.class, (Object)this.mongoTemplate));
        this.txManager = new MongoTransactionManager(this.mongoTemplate.getMongoDbFactory(), this.txOptions);
    }

    public MongockTemplate getMongockTemplate() {
        if (!this.isInitialized()) {
            throw new MongockException("Mongock Driver hasn't been initialized yet");
        }
        return this.dependencies.stream().filter(dependency -> MongockTemplate.class.isAssignableFrom(dependency.getType())).map(ChangeSetDependency::getInstance).map(instance -> (MongockTemplate)instance).findAny().orElseThrow(() -> new MongockException("Mongock Driver hasn't been initialized yet"));
    }

    public ChangeEntryService getChangeEntryService() {
        if (this.changeEntryRepository == null) {
            this.changeEntryRepository = new SpringDataMongoV3ChangeEntryRepository((MongoOperations)this.mongoTemplate, this.getMigrationRepositoryName(), this.getReadWriteConfiguration(), this.isTransactionable());
            this.changeEntryRepository.setIndexCreation(this.isIndexCreation());
        }
        return this.changeEntryRepository;
    }

    public Optional<Transactional> getTransactioner() {
        return Optional.ofNullable(this.transactionEnabled ? this : null);
    }

    public void executeInTransaction(Runnable operation) {
        TransactionStatus txStatus = this.getTxStatus((PlatformTransactionManager)this.txManager);
        try {
            this.mongoTemplate.setSessionSynchronization(SessionSynchronization.ALWAYS);
            operation.run();
            this.txManager.commit(txStatus);
        }
        catch (Exception ex) {
            logger.warn("Error in Mongock's transaction", (Throwable)ex);
            this.txManager.rollback(txStatus);
            throw new MongockException((Throwable)ex);
        }
    }

    protected TransactionStatus getTxStatus(PlatformTransactionManager txManager) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName("mongock-transaction-spring-data-3");
        def.setPropagationBehavior(0);
        return txManager.getTransaction((TransactionDefinition)def);
    }

    @Deprecated
    public void enableTransactionWithTxManager(PlatformTransactionManager txManager) {
        this.enableTransaction();
    }
}

