/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.changelogs;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import io.changock.migration.api.annotations.NonLockGuarded;
import io.changock.migration.api.annotations.NonLockGuardedType;
import io.mongock.api.config.LegacyMigration;
import io.mongock.api.config.LegacyMigrationMappingFields;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.entry.ChangeEntry;
import io.mongock.driver.api.entry.ChangeEntryService;
import io.mongock.driver.api.entry.ChangeState;
import io.mongock.driver.api.entry.ChangeType;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyService {
    private static final Logger logger = LoggerFactory.getLogger(LegacyService.class);

    public void executeMigration(@NonLockGuarded(value={NonLockGuardedType.NONE}) @Named(value="legacy-migration") LegacyMigration legacyMigration, MongoDatabase mongoDatabase, ChangeEntryService changeEntryService) {
        int changesMigrated = 0;
        Integer changesCountExpectation = legacyMigration.getChangesCountExpectation();
        if (changesCountExpectation == null) {
            logger.warn("[legacy-migration] - There is no changes count expectation!");
        }
        try {
            this.validateLegacyMigration(legacyMigration);
            List<ChangeEntry> changesToMigrate = this.getOriginalMigrationAsChangeEntryList((MongoCollection<Document>)mongoDatabase.getCollection(legacyMigration.getOrigin()), legacyMigration);
            Set allMigratedChanges = changeEntryService.getEntriesLog().stream().map(c -> String.format("%s-%s", c.getChangeId(), c.getAuthor())).collect(Collectors.toSet());
            Set executedChanges = changeEntryService.getExecuted().stream().map(c -> String.format("%s-%s", c.getChangeId(), c.getAuthor())).collect(Collectors.toSet());
            for (ChangeEntry originalChange : changesToMigrate) {
                boolean hasBeenPreviouslyMigrated = allMigratedChanges.contains(String.format("%s-%s", originalChange.getChangeId(), originalChange.getAuthor()));
                boolean migratedAndExecutedState = executedChanges.contains(String.format("%s-%s", originalChange.getChangeId(), originalChange.getAuthor()));
                if (migratedAndExecutedState) {
                    this.logAlreadyTracked(originalChange);
                } else {
                    ChangeEntry changeToInsert = hasBeenPreviouslyMigrated ? new ChangeEntry(originalChange.getExecutionId(), originalChange.getChangeId(), originalChange.getAuthor(), new Date(), originalChange.getState(), originalChange.getType(), originalChange.getChangeLogClass(), originalChange.getChangeSetMethod(), originalChange.getExecutionMillis(), originalChange.getExecutionHostname(), originalChange.getMetadata(), originalChange.getErrorTrace().orElse(""), Boolean.valueOf(false)) : originalChange;
                    this.logTracking(changeToInsert);
                    changeEntryService.saveOrUpdate(changeToInsert);
                    this.logSuccessfullyTracked(changeToInsert);
                }
                ++changesMigrated;
            }
            if (changesCountExpectation != null && changesCountExpectation != changesMigrated) {
                throw new MongockException(String.format("[legacy-migration] - Expectation [%d] changes migrated. Actual [%d] migrated", changesCountExpectation, changesMigrated));
            }
        }
        catch (MongockException ex) {
            this.processException(legacyMigration.isFailFast(), ex);
        }
        catch (Exception ex) {
            this.processException(legacyMigration.isFailFast(), new MongockException((Throwable)ex));
        }
    }

    private void processException(boolean isFailFast, MongockException ex) {
        if (isFailFast) {
            throw new MongockException((Throwable)ex);
        }
        logger.warn(ex.getMessage());
    }

    private List<ChangeEntry> getOriginalMigrationAsChangeEntryList(MongoCollection<Document> originalCollection, LegacyMigration legacyMigration) {
        ArrayList<ChangeEntry> originalMigrations = new ArrayList<ChangeEntry>();
        LegacyMigrationMappingFields mappingFields = legacyMigration.getMappingFields();
        FindIterable docs = originalCollection.find();
        MongoCursor iteratorOriginalMigration = docs.iterator();
        String executionId = this.getExecutionId();
        while (iteratorOriginalMigration.hasNext()) {
            Document changeDocument = (Document)iteratorOriginalMigration.next();
            ChangeEntry change = new ChangeEntry(executionId, this.getDocumentStringValue(changeDocument, mappingFields.getChangeId()), this.getDocumentStringValue(changeDocument, mappingFields.getAuthor()), this.getDocumentDateValue(changeDocument, mappingFields.getTimestamp()), ChangeState.EXECUTED, ChangeType.EXECUTION, this.getDocumentStringValue(changeDocument, mappingFields.getChangeLogClass()), this.getDocumentStringValue(changeDocument, mappingFields.getChangeSetMethod()), -1L, "unknown", this.buildMetadata(changeDocument, mappingFields.getMetadata()), Boolean.valueOf(false));
            originalMigrations.add(change);
        }
        return originalMigrations;
    }

    private Object buildMetadata(Document changeDocument, String field) {
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.put("migration-type", "legacy");
        String originalMetadata = field != null ? changeDocument.getString((Object)field) : null;
        if (originalMetadata != null) {
            newMetadata.put("original-metadata", originalMetadata);
        }
        return newMetadata;
    }

    private String getDocumentStringValue(Document changeDocument, String field) {
        return field != null ? changeDocument.getString((Object)field) : null;
    }

    private Date getDocumentDateValue(Document changeDocument, String field) {
        return field != null ? changeDocument.getDate((Object)field) : null;
    }

    private String getExecutionId() {
        return String.format("%s-%s-%d", "legacy_migration", LocalDateTime.now(), new Random().nextInt(999));
    }

    private void validateLegacyMigration(LegacyMigration legacyMigration) {
        if (legacyMigration == null || LegacyService.isEmpty(legacyMigration.getOrigin()) || legacyMigration.getMappingFields() == null || LegacyService.isEmpty(legacyMigration.getMappingFields().getChangeId()) || LegacyService.isEmpty(legacyMigration.getMappingFields().getAuthor())) {
            throw new MongockException("[legacy-migration] - wrong configured. Either is null, or doesn't contain collectionName or mapping fields are wrong");
        }
    }

    private static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    private void logAlreadyTracked(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Change[changeId: {} ][author: {} ] already tracked in Mongock changeLog collection", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }

    private void logSuccessfullyTracked(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Change[changeId: {} ][author: {} ] tracked successfully", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }

    private void logTracking(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Tracking change[changeId: {} ][author: {} ]...", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }
}

