/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.sync.v4.repository;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockPersistenceException;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.driver.mongodb.sync.v4.repository.MongoSync4RepositoryBase;
import io.mongock.driver.mongodb.sync.v4.repository.ReadWriteConfiguration;
import io.mongock.utils.DateUtils;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoSync4LockRepository
extends MongoSync4RepositoryBase<LockEntry>
implements LockRepositoryWithEntity<Document> {
    public MongoSync4LockRepository(MongoCollection<Document> collection) {
        super(collection, new String[]{"key"}, ReadWriteConfiguration.getDefault());
    }

    public MongoSync4LockRepository(MongoCollection<Document> collection, ReadWriteConfiguration readWriteConfiguration) {
        super(collection, new String[]{"key"}, readWriteConfiguration);
    }

    public void insertUpdate(LockEntry newLock) {
        this.insertUpdate(newLock, false);
    }

    public void updateIfSameOwner(LockEntry newLock) {
        this.insertUpdate(newLock, true);
    }

    public LockEntry findByKey(String lockKey) {
        Document result = (Document)this.collection.find((Bson)new Document().append("key", (Object)lockKey)).first();
        if (result != null) {
            return new LockEntry(result.getString((Object)"key"), result.getString((Object)"status"), result.getString((Object)"owner"), DateUtils.toDate((Object)result.get((Object)"expiresAt")));
        }
        return null;
    }

    public void removeByKeyAndOwner(String lockKey, String owner) {
        this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"key", (Object)lockKey), Filters.eq((String)"owner", (Object)owner)}));
    }

    protected void insertUpdate(LockEntry newLock, boolean onlyIfSameOwner) {
        boolean lockHeld;
        String debErrorDetail = "not db error";
        Bson acquireLockQuery = this.getAcquireLockQuery(newLock.getKey(), newLock.getOwner(), onlyIfSameOwner);
        Document newLockDocumentSet = new Document().append("$set", this.toEntity(newLock));
        try {
            UpdateResult result = this.collection.updateMany(acquireLockQuery, (Bson)newLockDocumentSet, new UpdateOptions().upsert(!onlyIfSameOwner));
            lockHeld = result.getModifiedCount() <= 0L && result.getUpsertedId() == null;
        }
        catch (MongoWriteException ex) {
            boolean bl = lockHeld = ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
            if (!lockHeld) {
                throw ex;
            }
            debErrorDetail = ex.getError().toString();
        }
        catch (DuplicateKeyException ex) {
            lockHeld = true;
            debErrorDetail = ex.getMessage();
        }
        if (lockHeld) {
            throw new LockPersistenceException(acquireLockQuery.toString(), newLockDocumentSet.toString(), debErrorDetail);
        }
    }

    protected Bson getAcquireLockQuery(String lockKey, String owner, boolean onlyIfSameOwner) {
        Bson expirationCond = Filters.lt((String)"expiresAt", (Object)new Date());
        Bson ownerCond = Filters.eq((String)"owner", (Object)owner);
        Bson keyCond = Filters.eq((String)"key", (Object)lockKey);
        Bson statusCond = Filters.eq((String)"status", (Object)LockStatus.LOCK_HELD.toString());
        return onlyIfSameOwner ? Filters.and((Bson[])new Bson[]{keyCond, statusCond, ownerCond}) : Filters.and((Bson[])new Bson[]{keyCond, Filters.or((Bson[])new Bson[]{expirationCond, ownerCond})});
    }
}

