/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.driver.mongodb.v3.repository;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.UpdateResult;
import io.mongock.driver.core.lock.LockEntry;
import io.mongock.driver.core.lock.LockPersistenceException;
import io.mongock.driver.core.lock.LockRepositoryWithEntity;
import io.mongock.driver.core.lock.LockStatus;
import io.mongock.driver.mongodb.v3.repository.Mongo3RepositoryBase;
import io.mongock.driver.mongodb.v3.repository.ReadWriteConfiguration;
import java.util.Date;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Mongo3LockRepository
extends Mongo3RepositoryBase<LockEntry>
implements LockRepositoryWithEntity<Document> {
    private static final String KEY_FIELD = "key";
    private static final String STATUS_FIELD = "status";
    private static final String OWNER_FIELD = "owner";
    private static final String EXPIRES_AT_FIELD = "expiresAt";

    public Mongo3LockRepository(MongoCollection<Document> collection) {
        super(collection, new String[]{KEY_FIELD}, ReadWriteConfiguration.getDefault());
    }

    public Mongo3LockRepository(MongoCollection<Document> collection, ReadWriteConfiguration readWriteConfiguration) {
        super(collection, new String[]{KEY_FIELD}, readWriteConfiguration);
    }

    public void insertUpdate(LockEntry newLock) {
        this.insertUpdate(newLock, false);
    }

    public void updateIfSameOwner(LockEntry newLock) {
        this.insertUpdate(newLock, true);
    }

    public LockEntry findByKey(String lockKey) {
        Document result = (Document)this.collection.find((Bson)new Document().append(KEY_FIELD, (Object)lockKey)).first();
        if (result != null) {
            return new LockEntry(result.getString((Object)KEY_FIELD), result.getString((Object)STATUS_FIELD), result.getString((Object)OWNER_FIELD), result.getDate((Object)EXPIRES_AT_FIELD));
        }
        return null;
    }

    public void removeByKeyAndOwner(String lockKey, String owner) {
        this.collection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)KEY_FIELD, (Object)lockKey), Filters.eq((String)OWNER_FIELD, (Object)owner)}));
    }

    protected void insertUpdate(LockEntry newLock, boolean onlyIfSameOwner) {
        boolean lockHeld;
        String debErrorDetail = "not db error";
        Bson acquireLockQuery = this.getAcquireLockQuery(newLock.getKey(), newLock.getOwner(), onlyIfSameOwner);
        Document newLockDocumentSet = new Document().append("$set", this.toEntity(newLock));
        try {
            UpdateResult result = this.collection.updateMany(acquireLockQuery, (Bson)newLockDocumentSet, new UpdateOptions().upsert(!onlyIfSameOwner));
            lockHeld = result.getModifiedCount() <= 0L && result.getUpsertedId() == null;
        }
        catch (MongoWriteException ex) {
            boolean bl = lockHeld = ex.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
            if (!lockHeld) {
                throw ex;
            }
            debErrorDetail = ex.getError().toString();
        }
        catch (DuplicateKeyException ex) {
            lockHeld = true;
            debErrorDetail = ex.getMessage();
        }
        if (lockHeld) {
            throw new LockPersistenceException(acquireLockQuery.toString(), newLockDocumentSet.toString(), debErrorDetail);
        }
    }

    protected Bson getAcquireLockQuery(String lockKey, String owner, boolean onlyIfSameOwner) {
        Bson expirationCond = Filters.lt((String)EXPIRES_AT_FIELD, (Object)new Date());
        Bson ownerCond = Filters.eq((String)OWNER_FIELD, (Object)owner);
        Bson keyCond = Filters.eq((String)KEY_FIELD, (Object)lockKey);
        Bson statusCond = Filters.eq((String)STATUS_FIELD, (Object)LockStatus.LOCK_HELD.toString());
        return onlyIfSameOwner ? Filters.and((Bson[])new Bson[]{keyCond, statusCond, ownerCond}) : Filters.and((Bson[])new Bson[]{keyCond, Filters.or((Bson[])new Bson[]{expirationCond, ownerCond})});
    }
}

