/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.standalone;

import io.mongock.api.config.MongockConfiguration;
import io.mongock.api.exception.MongockException;
import io.mongock.driver.api.driver.ConnectionDriver;
import io.mongock.professional.config.MongockConfigurationProfessional;
import io.mongock.professional.runner.common.executor.ExecutorBuilderProfessional;
import io.mongock.professional.runner.common.license.LicenseChecker;
import io.mongock.professional.runner.common.multitenant.runner.MongockMultiRunner;
import io.mongock.professional.runner.common.multitenant.runner.MongockRunnerTenantSelector;
import io.mongock.professional.runner.common.multitenant.supplier.DriverSupplier;
import io.mongock.professional.runner.common.multitenant.supplier.DriverSupplierTenant;
import io.mongock.professional.runner.common.multitenant.wrapper.MultiTenant;
import io.mongock.professional.runner.common.multitenant.wrapper.MultiTenantSelectable;
import io.mongock.runner.core.builder.BuilderType;
import io.mongock.runner.core.executor.ExecutorBuilder;
import io.mongock.runner.core.executor.MongockRunner;
import io.mongock.runner.core.executor.changelog.ChangeLogService;
import io.mongock.runner.core.executor.changelog.ChangeLogServiceBase;
import io.mongock.runner.core.executor.operation.Operation;
import io.mongock.runner.standalone.RunnerStandaloneBuilder;
import io.mongock.runner.standalone.base.StandaloneBuilderBase;
import java.util.List;
import java.util.stream.Collectors;

public final class MongockStandalone {
    public static RunnerStandaloneBuilder builder() {
        return new RunnerStandaloneBuilderImpl(new ExecutorBuilderProfessional(LicenseChecker.INSTANCE), new ChangeLogService(), new MongockConfigurationProfessional(), LicenseChecker.INSTANCE);
    }

    public static class RunnerStandaloneBuilderImpl
    extends StandaloneBuilderBase<RunnerStandaloneBuilderImpl, MongockConfigurationProfessional>
    implements RunnerStandaloneBuilder {
        protected LicenseChecker licenseChecker;
        protected MultiTenant multiTenant;

        RunnerStandaloneBuilderImpl(ExecutorBuilderProfessional executorBuilder, ChangeLogService changeLogService, MongockConfigurationProfessional config, LicenseChecker licenseChecker) {
            super(BuilderType.PROFESSIONAL, (ExecutorBuilder)executorBuilder, (ChangeLogServiceBase)changeLogService, (MongockConfiguration)config);
            this.licenseChecker = licenseChecker;
        }

        protected void validateConfigurationAndInjections(ConnectionDriver driver) throws MongockException {
            super.validateConfigurationAndInjections(driver);
        }

        public RunnerStandaloneBuilderImpl setDriverMultiTenant(MultiTenant multiTenant) {
            this.multiTenant = multiTenant;
            return this.getInstance();
        }

        public MongockRunner buildRunner(Operation operation) {
            return this.isMultiTenant() ? new MongockMultiRunner(this.getMultiRunnersFromDrivers(operation), this.licenseChecker, ((MongockConfigurationProfessional)this.config).getLicenseKey()) : super.buildRunner(operation);
        }

        private List<MongockRunner> getMultiRunnersFromDrivers(Operation operation) {
            return this.multiTenant.getDriverSuppliers().stream().map(driverSupplier -> this.getMongockRunner(operation, (DriverSupplier)driverSupplier)).collect(Collectors.toList());
        }

        private MongockRunner getMongockRunner(Operation operation, DriverSupplier driverSupplier) {
            MongockRunner runner = this.buildRunner(operation, (ConnectionDriver)driverSupplier.get());
            if (MultiTenantSelectable.class.isAssignableFrom(this.multiTenant.getClass())) {
                return new MongockRunnerTenantSelector(runner, ((DriverSupplierTenant)driverSupplier).getTenantId(), ((MultiTenantSelectable)this.multiTenant).getTenantSelector());
            }
            return runner;
        }

        private boolean isMultiTenant() {
            return this.multiTenant != null;
        }

        public RunnerStandaloneBuilderImpl getInstance() {
            return this;
        }
    }
}

