/*
 * Copyright (c) 2014-2016 by its authors. Some rights reserved.
 * See the project homepage at: https://monix.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package monix.eval.internal

import monix.eval.{Callback, Task}

private[monix] object TaskDelayExecutionWith {
  /**
    * Implementation for `Task.delayExecutionWith`
    */
  def apply[A](self: Task[A], trigger: Task[Any]): Task[A] =
    Task.unsafeCreate { (context, cb) =>
      implicit val s = context.scheduler

      Task.unsafeStartAsync(trigger, context,
        new Callback[Any] {
          def onSuccess(value: Any): Unit = {
            // Async boundary forced, prevents stack-overflows
            Task.unsafeStartAsync(self, context, Callback.async(cb))
          }

          def onError(ex: Throwable): Unit =
            cb.asyncOnError(ex)
        })
    }
}
