/*
 * Decompiled with CFR 0.152.
 */
package monix.eval.internal;

import java.io.Serializable;
import monix.eval.Coeval;
import monix.eval.internal.CoevalStackTracedContext;
import monix.eval.internal.StackFrame;
import monix.eval.internal.TracingPlatform;
import monix.eval.tracing.CoevalEvent;
import monix.eval.tracing.CoevalTrace$;
import monix.execution.internal.collection.ChunkedArrayStack;
import monix.execution.internal.collection.ChunkedArrayStack$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CoevalRunLoop$ {
    public static final CoevalRunLoop$ MODULE$ = new CoevalRunLoop$();
    private static final List<String> runLoopFilter = (List)new .colon.colon((Object)"monix.eval.", (List)new .colon.colon((Object)"scala.runtime.", (List)Nil$.MODULE$));
    private static volatile boolean bitmap$init$0 = true;

    public <A> Coeval.Eager<A> start(Coeval<A> source) {
        Coeval current = source;
        Coeval.Map bFirst = null;
        ChunkedArrayStack bRest = null;
        boolean hasUnboxed = false;
        Object unboxed = null;
        CoevalStackTracedContext tracingCtx = null;
        while (true) {
            BoxedUnit boxedUnit;
            Coeval<A> coeval;
            if ((coeval = current) instanceof Coeval.FlatMap) {
                Coeval.FlatMap flatMap = (Coeval.FlatMap)coeval;
                Coeval fa = flatMap.source();
                Coeval.Map bindNext = flatMap.f();
                if (TracingPlatform.isStackTracing) {
                    Object trace = flatMap.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new CoevalStackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((CoevalEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push(bFirst);
                }
                bFirst = bindNext;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (coeval instanceof Coeval.Now) {
                Coeval.Now now = (Coeval.Now)coeval;
                Object value = now.a();
                unboxed = value;
                hasUnboxed = true;
                boxedUnit = BoxedUnit.UNIT;
            } else if (coeval instanceof Coeval.Always) {
                BoxedUnit boxedUnit2;
                Coeval.Always always = (Coeval.Always)coeval;
                Function0 thunk = always.f();
                try {
                    unboxed = thunk.apply();
                    hasUnboxed = true;
                    current = null;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable2)) {
                        throw throwable;
                    }
                    current = new Coeval.Error(throwable2);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
            } else if (coeval instanceof Coeval.Map) {
                Coeval.Map map = (Coeval.Map)coeval;
                Coeval fa = map.source();
                if (TracingPlatform.isStackTracing) {
                    Object trace = map.trace();
                    if (tracingCtx == null) {
                        tracingCtx = new CoevalStackTracedContext();
                    }
                    if (trace != null) {
                        tracingCtx.pushEvent((CoevalEvent)trace);
                    }
                }
                if (bFirst != null) {
                    if (bRest == null) {
                        bRest = ChunkedArrayStack$.MODULE$.apply(ChunkedArrayStack$.MODULE$.apply$default$1());
                    }
                    bRest.push((Object)bFirst);
                }
                bFirst = map;
                current = fa;
                boxedUnit = BoxedUnit.UNIT;
            } else if (coeval instanceof Coeval.Suspend) {
                BoxedUnit boxedUnit4;
                Coeval.Suspend suspend = (Coeval.Suspend)coeval;
                Function0 thunk = suspend.thunk();
                try {
                    current = (Coeval.Error)thunk.apply();
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable3 = throwable;
                    if (!NonFatal$.MODULE$.apply(throwable3)) {
                        throw throwable;
                    }
                    current = new Coeval.Error(throwable3);
                    BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit4;
            } else if (coeval instanceof Coeval.Error) {
                StackFrame<Object, Coeval<Object>> stackFrame;
                Coeval.Error error = (Coeval.Error)coeval;
                Throwable ex = error.error();
                if (TracingPlatform.isStackTracing && TracingPlatform.enhancedExceptions) {
                    if (tracingCtx == null) {
                        tracingCtx = new CoevalStackTracedContext();
                    }
                    this.augmentException(ex, tracingCtx);
                }
                if ((stackFrame = this.findErrorHandler(bFirst, (ChunkedArrayStack<Function1<Object, Coeval<Object>>>)bRest)) == null) {
                    return error;
                }
                try {
                    current = stackFrame.recover(ex);
                }
                catch (Throwable throwable) {
                    Throwable throwable4 = throwable;
                    if (NonFatal$.MODULE$.apply(throwable4)) {
                        current = new Coeval.Error(throwable4);
                        BoxedUnit boxedUnit6 = BoxedUnit.UNIT;
                    }
                    throw throwable;
                }
                bFirst = null;
                BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (coeval instanceof Coeval.Trace) {
                Coeval.Trace trace = (Coeval.Trace)coeval;
                Coeval.Error sourceTask = trace.source();
                CoevalEvent frame = trace.trace();
                if (tracingCtx == null) {
                    tracingCtx = new CoevalStackTracedContext();
                }
                tracingCtx.pushEvent(frame);
                current = sourceTask;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(coeval);
            }
            if (!hasUnboxed) continue;
            Function1<Object, Coeval<Object>> function1 = this.popNextBind(bFirst, (ChunkedArrayStack<Function1<Object, Coeval<Object>>>)bRest);
            if (function1 == null) {
                return current != null ? current : new Coeval.Now<Object>(unboxed);
            }
            try {
                current = (Coeval)function1.apply(unboxed);
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                if (NonFatal$.MODULE$.apply(throwable5)) {
                    current = new Coeval.Error(throwable5);
                    BoxedUnit boxedUnit8 = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            hasUnboxed = false;
            unboxed = null;
            bFirst = null;
            BoxedUnit boxedUnit9 = BoxedUnit.UNIT;
        }
    }

    private StackFrame<Object, Coeval<Object>> findErrorHandler(Function1<Object, Coeval<Object>> bFirst, ChunkedArrayStack<Function1<Object, Coeval<Object>>> bRest) {
        StackFrame stackFrame;
        Function1<Object, Coeval<Object>> function1 = bFirst;
        if (function1 instanceof StackFrame) {
            StackFrame stackFrame2;
            stackFrame = stackFrame2 = (StackFrame)function1;
        } else {
            if (bRest != null) {
                Function1 ref;
                do {
                    if ((ref = (Function1)bRest.pop()) != null) continue;
                    return null;
                } while (!(ref instanceof StackFrame));
                return (StackFrame)ref;
            }
            stackFrame = null;
        }
        return stackFrame;
    }

    private Function1<Object, Coeval<Object>> popNextBind(Function1<Object, Coeval<Object>> bFirst, ChunkedArrayStack<Function1<Object, Coeval<Object>>> bRest) {
        Function1 next;
        if (bFirst != null && !(bFirst instanceof StackFrame.ErrorHandler)) {
            return bFirst;
        }
        if (bRest == null) {
            return null;
        }
        do {
            if ((next = (Function1)bRest.pop()) != null) continue;
            return null;
        } while (next instanceof StackFrame.ErrorHandler);
        return next;
    }

    public void augmentException(Throwable ex, CoevalStackTracedContext ctx) {
        block1: {
            boolean augmented;
            StackTraceElement[] stackTrace = ex.getStackTrace();
            if (!ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])stackTrace))) break block1;
            boolean bl = augmented = stackTrace[stackTrace.length - 1].getClassName().indexOf(64) != -1;
            if (!augmented) {
                StackTraceElement[] prefix = this.dropRunLoopFrames(stackTrace);
                StackTraceElement[] suffix = (StackTraceElement[])ctx.getStackTraces().flatMap((Function1 & Serializable)t -> CoevalTrace$.MODULE$.getOpAndCallSite(t.stackTrace())).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    StackTraceElement methodSite = (StackTraceElement)tuple2._1();
                    StackTraceElement callSite = (StackTraceElement)tuple2._2();
                    String op = NameTransformer$.MODULE$.decode(methodSite.getMethodName());
                    StackTraceElement stackTraceElement = new StackTraceElement(new StringBuilder(3).append(op).append(" @ ").append(callSite.getClassName()).toString(), callSite.getMethodName(), callSite.getFileName(), callSite.getLineNumber());
                    return stackTraceElement;
                }).toArray(ClassTag$.MODULE$.apply(StackTraceElement.class));
                ex.setStackTrace((StackTraceElement[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])prefix), (Object)suffix, ClassTag$.MODULE$.apply(StackTraceElement.class)));
            }
        }
    }

    private StackTraceElement[] dropRunLoopFrames(StackTraceElement[] frames) {
        return (StackTraceElement[])ArrayOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.refArrayOps((Object[])frames), (Function1 & Serializable)ste -> BoxesRunTime.boxToBoolean((boolean)CoevalRunLoop$.$anonfun$dropRunLoopFrames$1(ste)));
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$2(StackTraceElement ste$1, String x$1) {
        return ste$1.getClassName().startsWith(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropRunLoopFrames$1(StackTraceElement ste) {
        return !runLoopFilter.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CoevalRunLoop$.$anonfun$dropRunLoopFrames$2(ste, x$1)));
    }

    private CoevalRunLoop$() {
    }
}

